/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import java.math.BigDecimal;
import java.util.function.Consumer;

public final class CheckNumber {
    private CheckNumber() {
    }

    public static Consumer<Number> min(Number min) {
        return value -> {
            if (min != null && new BigDecimal(value.toString()).compareTo(new BigDecimal(min.toString())) < 0) {
                throw new IllegalArgumentException("must not be smaller than " + min);
            }
        };
    }

    public static Consumer<Number> max(Number max) {
        return value -> {
            if (max != null && new BigDecimal(value.toString()).compareTo(new BigDecimal(max.toString())) > 0) {
                throw new IllegalArgumentException("must not be larger than " + max);
            }
        };
    }

    public static Consumer<Number> lessThan(Number n) {
        return value -> {
            if (n != null && new BigDecimal(value.toString()).compareTo(new BigDecimal(n.toString())) <= 0) {
                throw new IllegalArgumentException("must be less than " + n);
            }
        };
    }

    public static Consumer<Number> greaterThan(Number n) {
        return value -> {
            if (n != null && new BigDecimal(value.toString()).compareTo(new BigDecimal(n.toString())) <= 0) {
                throw new IllegalArgumentException("must be greater than " + n);
            }
        };
    }
}

