/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import ch.frostnova.util.check.Check;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public final class CheckCollection {
    private CheckCollection() {
    }

    public static Consumer<Collection> notEmpty() {
        return Check.with(c -> !c.isEmpty(), "must not be empty");
    }

    public static Consumer<Collection> noNullElements() {
        return Check.with(c -> !c.stream().anyMatch(Objects::isNull), "must not be empty");
    }

    public static Consumer<Collection> min(int min) {
        return Check.with(v -> v.size() >= min, "must have at least " + min + " elements");
    }

    public static Consumer<Collection> max(int max) {
        return Check.with(v -> v.size() <= max, "must have no more than " + max + " elements");
    }
}

