/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Check {
    private Check() {
    }

    public static <T> Consumer<T> with(Predicate<? super T> predicate, Function<T, String> errorMessageProducer) {
        Check.required(predicate, "predicate", new Consumer[0]);
        Check.required(errorMessageProducer, "error message producer", new Consumer[0]);
        return value -> {
            if (!predicate.test(value)) {
                throw new IllegalArgumentException((String)errorMessageProducer.apply(value));
            }
        };
    }

    public static <T> Consumer<T> with(Predicate<? super T> predicate, String errorMessage) {
        return Check.with(predicate, (T value) -> errorMessage);
    }

    @SafeVarargs
    public static <T> T optional(T value, String parameterName, Consumer<? super T> ... validators) {
        return value == null ? null : (T)Check.required(value, parameterName, validators);
    }

    @SafeVarargs
    public static <T> T required(T value, String parameterName, Consumer<? super T> ... validators) {
        if (value == null) {
            throw new IllegalArgumentException(Check.name(parameterName) + " is required");
        }
        if (validators != null) {
            for (Consumer<T> consumer : validators) {
                try {
                    consumer.accept(value);
                }
                catch (Exception ex) {
                    String message = ex.getMessage() != null ? ex.getMessage() : "unknown reason";
                    throw new IllegalArgumentException(Check.name(parameterName) + " " + message);
                }
            }
        }
        return value;
    }

    private static String name(String parameterName) {
        return parameterName != null ? "'" + parameterName + "'" : "value";
    }
}

