/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;

public final class CheckCollection {
    private CheckCollection() {
    }

    public static Consumer<Collection> notEmpty() {
        return value -> {
            if (value.isEmpty()) {
                throw new IllegalArgumentException("must not be empty");
            }
        };
    }

    public static Consumer<Collection> noNullElements() {
        return value -> {
            if (value.stream().anyMatch(Objects::isNull)) {
                throw new IllegalArgumentException("must not contain null elements");
            }
        };
    }

    public static Consumer<Collection> min(int min) {
        return value -> {
            if (value.size() < min) {
                throw new IllegalArgumentException("must have at least " + min + " elements");
            }
        };
    }

    public static Consumer<Collection> max(int max) {
        return value -> {
            if (value.size() > max) {
                throw new IllegalArgumentException("must have no more than " + max + " elements");
            }
        };
    }
}

