/*
 * Decompiled with CFR 0.152.
 */
package ch.frostnova.util.check;

import java.util.function.Consumer;

public final class Check {
    private Check() {
    }

    @SafeVarargs
    public static <T> T optional(T value, String parameterName, Consumer<? super T> ... validators) {
        return value == null ? null : (T)Check.required(value, parameterName, validators);
    }

    @SafeVarargs
    public static <T> T required(T value, String parameterName, Consumer<? super T> ... validators) {
        if (value == null) {
            throw new IllegalArgumentException(Check.name(parameterName) + " is required");
        }
        if (validators != null) {
            for (Consumer<T> consumer : validators) {
                try {
                    consumer.accept(value);
                }
                catch (Exception ex) {
                    String message = ex.getMessage() != null ? ex.getMessage() : "unknown reason";
                    throw new IllegalArgumentException(Check.name(parameterName) + ": " + message);
                }
            }
        }
        return value;
    }

    private static String name(String parameterName) {
        return parameterName != null ? "'" + parameterName + "'" : "value";
    }
}

