/*
 * Decompiled with CFR 0.152.
 */
package ch.exense.viz.rest;

import ch.exense.viz.persistence.accessors.DataTableWrapper;
import ch.exense.viz.persistence.accessors.GenericVizAccessor;
import ch.exense.viz.persistence.accessors.MongoResult;
import ch.exense.viz.persistence.accessors.ObjectWrapper;
import ch.exense.viz.persistence.accessors.PagedDataTableWrapper;
import ch.exense.viz.proxy.ProxiedRequest;
import ch.exense.viz.proxy.ProxiedResponse;
import ch.exense.viz.proxy.ProxyService;
import ch.exense.viz.rest.DirectMongoQuery;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/viz")
public class VizServlet {
    private static final Logger logger = LoggerFactory.getLogger(VizServlet.class);
    @Inject
    GenericVizAccessor accessor;

    @POST
    @Path(value="/crud/{collection}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response saveObject(@PathParam(value="collection") String collection, @QueryParam(value="name") String name, Object vizObject) {
        logger.info("Saving object: " + vizObject + " to collection: " + collection);
        Object found = this.accessor.findByAttribute("name", (Object)name, collection, Object.class);
        if (found != null) {
            this.accessor.removeByAttribute("name", (Object)name, collection);
            logger.debug("Removed existing object: " + found + " with name: " + name);
        }
        this.accessor.insertObject((Object)new ObjectWrapper(name, vizObject), collection);
        return Response.status((int)200).entity(found).build();
    }

    @GET
    @Path(value="/crud/{collection}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Object loadObject(@PathParam(value="collection") String collection, @QueryParam(value="name") String name) {
        logger.debug("Loading object by name: " + name + " from collection: " + collection);
        return Response.status((int)200).entity(this.accessor.findByAttribute("name", (Object)name, collection, Object.class)).build();
    }

    @GET
    @Path(value="/crud/all/{collection}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Object getAll(@PathParam(value="collection") String collection) {
        logger.debug("Loading full collection: " + collection);
        return Response.status((int)200).entity((Object)new DataTableWrapper(this.accessor.getAll(collection).getData())).build();
    }

    @POST
    @Path(value="/crud/paged/{collection}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public Object getData(@PathParam(value="collection") String collection, MultivaluedMap<String, String> form) {
        logger.debug("Loading paged collection: " + collection);
        int draw = Integer.parseInt((String)((List)form.get((Object)"draw")).get(0));
        int skip = Integer.parseInt((String)((List)form.get((Object)"start")).get(0));
        int limit = skip + Integer.parseInt((String)((List)form.get((Object)"length")).get(0));
        String searchValue = (String)((List)form.get((Object)"search[value]")).get(0);
        String query = "{}";
        if (searchValue != null && !searchValue.isEmpty()) {
            query = "{\"name\": { $regex : '" + searchValue + "' }}";
        }
        MongoResult result = this.accessor.execute(collection, query, skip, limit, "{\"name\" : 1}", "");
        PagedDataTableWrapper pagedDataTableResponse = this.toPagedDataTable(result.getData(), draw, result.getCount());
        return Response.status((int)200).entity((Object)pagedDataTableResponse).build();
    }

    private PagedDataTableWrapper toPagedDataTable(List<ObjectWrapper> data, int draw, long count) {
        PagedDataTableWrapper wrapper = new PagedDataTableWrapper(data);
        wrapper.setDraw(Integer.valueOf(draw).intValue());
        wrapper.setRecordsFiltered(count);
        wrapper.setRecordsTotal(count);
        return wrapper;
    }

    @DELETE
    @Path(value="/crud/{collection}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Object deleteObject(@PathParam(value="collection") String collection, @QueryParam(value="name") String name) {
        logger.debug("Removing object by name: " + name + " from collection: " + collection);
        this.accessor.removeByAttribute("name", (Object)name, collection);
        return Response.status((int)200).entity(null).build();
    }

    @POST
    @Path(value="/proxy")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response proxyQuery(ProxiedRequest request) {
        ProxiedResponse response = new ProxyService().executeProxiedQuery(request);
        return Response.status((int)response.getCode()).entity((Object)response.getData()).build();
    }

    @POST
    @Path(value="/driver")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response driverQuery(DirectMongoQuery request) {
        List result = null;
        try {
            if (request.getCollection() == null || request.getCollection().trim().isEmpty()) {
                throw new Exception("Please provide a collection name.");
            }
            result = request.getHost() != null ? this.accessor.execute(request.getHost(), request.getPort(), request.getDatabase(), request.getCollection(), request.getQuery(), request.getSkip(), request.getLimit(), request.getSort(), request.getProjection()) : this.accessor.execute(request.getCollection(), request.getQuery(), request.getSkip(), request.getLimit(), request.getSort(), request.getProjection()).getData();
            return Response.status((int)200).entity((Object)result).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((int)500).entity((Object)("{ \"error\" : \"" + e.getClass() + ": " + e.getMessage() + "\"}")).build();
        }
    }
}

