/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import groovy.lang.GString;
import java.util.Map;
import step.core.dynamicbeans.DynamicValue;
import step.core.dynamicbeans.EvaluationResult;
import step.expressions.ExpressionHandler;

public class DynamicValueResolver {
    private ExpressionHandler expressionHandler;

    public DynamicValueResolver(ExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public void evaluate(DynamicValue<?> dynamicValue, Map<String, Object> bindings) {
        if (dynamicValue.isDynamic()) {
            String exprType = dynamicValue.expressionType;
            EvaluationResult result = new EvaluationResult();
            try {
                Object evaluationResult = this.expressionHandler.evaluateGroovyExpression(dynamicValue.expression, bindings);
                if (evaluationResult instanceof GString) {
                    evaluationResult = evaluationResult.toString();
                }
                result.setResultValue(evaluationResult);
            }
            catch (Exception e) {
                result.setEvaluationException(e);
            }
            dynamicValue.evalutationResult = result;
        }
    }
}

