/*
 * Decompiled with CFR 0.152.
 */
package step.attachments;

import java.io.File;
import org.bson.types.ObjectId;
import step.attachments.AttachmentContainer;
import step.attachments.AttachmentMeta;
import step.attachments.AttachmentMetaAccessor;
import step.commons.conf.Configuration;
import step.commons.helpers.FileHelper;

public class AttachmentManager {
    protected Configuration configuration;
    protected String filerPath;

    public AttachmentManager(Configuration configuration) {
        this.configuration = configuration;
        this.filerPath = configuration.getProperty("attachmentsdir", "attachments");
    }

    public AttachmentContainer createAttachmentContainer() {
        AttachmentMeta meta = new AttachmentMeta();
        AttachmentMetaAccessor accessor = new AttachmentMetaAccessor();
        accessor.save(meta);
        File containerFolder = this.getContainerFileById(meta.getId());
        containerFolder.mkdirs();
        AttachmentContainer container = new AttachmentContainer();
        container.setMeta(meta);
        container.setContainer(containerFolder);
        return container;
    }

    private File getContainerFileById(ObjectId id) {
        return new File(this.filerPath + "/" + id.toString());
    }

    public File getFileById(String id) {
        return this.getFileById(new ObjectId(id));
    }

    @Deprecated
    public File getFileById(ObjectId id) {
        File folder = this.getContainerFileById(id);
        String[] list = folder.list();
        if (list != null && list.length > 0) {
            File file = new File(folder + "/" + list[0]);
            return file;
        }
        throw new RuntimeException("The attachment with ID " + id + " doesn't exist.");
    }

    public void deleteContainer(String id) {
        File folder = this.getContainerFileById(new ObjectId(id));
        FileHelper.deleteFolder((File)folder);
    }
}

