/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import java.util.Map;
import javax.json.JsonObject;
import step.expressions.ExpressionHandler;

public class DynamicJsonValueResolver {
    private ExpressionHandler expressionHandler;

    public DynamicJsonValueResolver(ExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public Object evaluate(JsonObject dynamicValueAsJson, Map<String, Object> bindings) {
        boolean isDynamic = dynamicValueAsJson.getBoolean("dynamic");
        if (isDynamic) {
            String exprType = dynamicValueAsJson.containsKey((Object)"expressionType") ? dynamicValueAsJson.getString("expressionType") : null;
            String expression = dynamicValueAsJson.getString("expression");
            try {
                return this.expressionHandler.evaluateGroovyExpression(expression, bindings);
            }
            catch (Exception e) {
                throw new RuntimeException("Error evaluating " + expression, e);
            }
        }
        return dynamicValueAsJson.get((Object)"value");
    }
}

