/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.dynamicbeans.DynamicJsonValueResolver;

public class DynamicJsonObjectResolver {
    private static Logger logger = LoggerFactory.getLogger(DynamicJsonObjectResolver.class);
    DynamicJsonValueResolver valueResolver;
    private static JsonProvider jprov = JsonProvider.provider();

    public DynamicJsonObjectResolver(DynamicJsonValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }

    public JsonObject evaluate(JsonObject o, Map<String, Object> bindings) {
        JsonObjectBuilder builder = jprov.createObjectBuilder();
        if (o != null) {
            for (String key : o.keySet()) {
                JsonValue v = (JsonValue)o.get((Object)key);
                Object result = this.evaluateJsonValue(v, bindings);
                if (result instanceof JsonValue) {
                    builder.add(key, (JsonValue)result);
                    continue;
                }
                if (result instanceof Boolean) {
                    builder.add(key, ((Boolean)result).booleanValue());
                    continue;
                }
                if (result instanceof Integer) {
                    builder.add(key, ((Integer)result).intValue());
                    continue;
                }
                if (result instanceof String) {
                    builder.add(key, (String)result);
                    continue;
                }
                if (result != null) {
                    builder.add(key, result.toString());
                    continue;
                }
                builder.add(key, "");
            }
        }
        return builder.build();
    }

    private Object evaluateJsonValue(JsonValue v, Map<String, Object> bindings) {
        if (v instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)v;
            if (jsonObject.containsKey((Object)"dynamic")) {
                return this.valueResolver.evaluate(jsonObject, bindings);
            }
            return this.evaluate(jsonObject, bindings);
        }
        if (v instanceof JsonArray) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            JsonArray jsonArray = (JsonArray)v;
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonValue jsonValue = (JsonValue)jsonArray.get(i);
                Object o = this.evaluateJsonValue(jsonValue, bindings);
                if (o instanceof JsonValue) {
                    arrayBuilder.add((JsonValue)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    arrayBuilder.add(((Boolean)o).booleanValue());
                    continue;
                }
                if (o instanceof Integer) {
                    arrayBuilder.add(((Integer)o).intValue());
                    continue;
                }
                if (o instanceof String) {
                    arrayBuilder.add((String)o);
                    continue;
                }
                arrayBuilder.add(o.toString());
            }
            return arrayBuilder.build();
        }
        return v;
    }
}

