/*
 * Decompiled with CFR 0.152.
 */
package step.core.dynamicbeans;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.dynamicbeans.ContainsDynamicValues;
import step.core.dynamicbeans.DynamicValue;
import step.core.dynamicbeans.DynamicValueResolver;

public class DynamicBeanResolver {
    private static Logger logger = LoggerFactory.getLogger(DynamicBeanResolver.class);
    DynamicValueResolver valueResolver;
    Map<Class<?>, BeanInfo> beanInfoCache = new ConcurrentHashMap();

    public DynamicBeanResolver(DynamicValueResolver valueResolver) {
        this.valueResolver = valueResolver;
    }

    public void evaluate(Object o, Map<String, Object> bindings) {
        if (o != null) {
            Class<?> clazz = o.getClass();
            try {
                BeanInfo beanInfo = this.beanInfoCache.get(clazz);
                if (beanInfo == null) {
                    beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                    this.beanInfoCache.put(clazz, beanInfo);
                }
                for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                    Object value;
                    Method method = descriptor.getReadMethod();
                    if (method == null) continue;
                    if (method.getReturnType().equals(DynamicValue.class)) {
                        value = method.invoke(o, new Object[0]);
                        if (value == null) continue;
                        DynamicValue dynamicValue = (DynamicValue)value;
                        this.valueResolver.evaluate(dynamicValue, bindings);
                        this.evaluate(dynamicValue.get(), bindings);
                        continue;
                    }
                    if (!method.isAnnotationPresent(ContainsDynamicValues.class)) continue;
                    value = method.invoke(o, new Object[0]);
                    this.evaluate(value, bindings);
                }
            }
            catch (Exception e) {
                logger.warn("Error while evaluating object: " + o.toString(), (Throwable)e);
            }
        }
    }

    public <T> T cloneDynamicValues(T o) {
        if (o != null) {
            try {
                Class<?> clazz = o.getClass();
                Object out = clazz.newInstance();
                BeanInfo beanInfo = this.beanInfoCache.get(clazz);
                if (beanInfo == null) {
                    beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                    this.beanInfoCache.put(clazz, beanInfo);
                }
                for (PropertyDescriptor descriptor : beanInfo.getPropertyDescriptors()) {
                    Object newValue;
                    Method method = descriptor.getReadMethod();
                    if (method == null) continue;
                    Object oldValue = method.invoke(o, new Object[0]);
                    if (oldValue != null) {
                        if (oldValue instanceof DynamicValue) {
                            DynamicValue dynamicValue = (DynamicValue)oldValue;
                            newValue = dynamicValue.cloneValue();
                        } else {
                            newValue = method.isAnnotationPresent(ContainsDynamicValues.class) ? this.cloneDynamicValues(oldValue) : oldValue;
                        }
                    } else {
                        newValue = null;
                    }
                    Method writeMethod = descriptor.getWriteMethod();
                    if (writeMethod != null) {
                        descriptor.getWriteMethod().invoke(out, newValue);
                        continue;
                    }
                    throw new RuntimeException("Unable to clone object " + o.toString() + ". No setter found for " + descriptor);
                }
                return (T)out;
            }
            catch (Exception e) {
                throw new RuntimeException("Error while cloning object " + o.toString(), e);
            }
        }
        return null;
    }
}

