/*
 * Decompiled with CFR 0.152.
 */
package step.resources;

import ch.exense.commons.io.FileHelper;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.objectenricher.ObjectEnricher;
import step.resources.CustomResourceType;
import step.resources.Resource;
import step.resources.ResourceAccessor;
import step.resources.ResourceManager;
import step.resources.ResourceRevision;
import step.resources.ResourceRevisionAccessor;
import step.resources.ResourceRevisionContainer;
import step.resources.ResourceRevisionContent;
import step.resources.ResourceRevisionContentImpl;
import step.resources.ResourceRevisionFileHandle;
import step.resources.ResourceRevisionFileHandleImpl;
import step.resources.ResourceType;
import step.resources.SimilarResourceExistingException;

public class ResourceManagerImpl
implements ResourceManager {
    protected final File resourceRootFolder;
    protected final ResourceAccessor resourceAccessor;
    protected final ResourceRevisionAccessor resourceRevisionAccessor;
    protected final Map<String, ResourceType> resourceTypes;
    protected static final Logger logger = LoggerFactory.getLogger(ResourceManagerImpl.class);

    public ResourceManagerImpl(File resourceRootFolder, ResourceAccessor resourceAccessor, ResourceRevisionAccessor resourceRevisionAccessor) {
        this.resourceRootFolder = resourceRootFolder;
        this.resourceAccessor = resourceAccessor;
        this.resourceRevisionAccessor = resourceRevisionAccessor;
        this.resourceTypes = new ConcurrentHashMap<String, ResourceType>();
        this.resourceTypes.put("temp", (ResourceType)new CustomResourceType(true));
        this.resourceTypes.put("attachment", (ResourceType)new CustomResourceType(false));
        this.resourceTypes.put("stagingContextFiles", (ResourceType)new CustomResourceType(false));
        this.resourceTypes.put("functions", (ResourceType)new CustomResourceType(false));
        this.resourceTypes.put("datasource", (ResourceType)new CustomResourceType(false));
        this.resourceTypes.put("secret", (ResourceType)new CustomResourceType(false));
        this.resourceTypes.put("pdfTestScenarioFile", (ResourceType)new CustomResourceType(false));
    }

    public void registerResourceType(String name, ResourceType resourceType) {
        this.resourceTypes.put(name, resourceType);
    }

    @Override
    public ResourceRevisionContainer createResourceContainer(String resourceType, String resourceFileName) throws IOException {
        Resource resource = this.createResource(resourceType, resourceFileName);
        ResourceRevision revision = this.createResourceRevision(resourceFileName, resource.getId().toString());
        this.createResourceRevisionContainer(resource, revision);
        File file = this.getResourceRevisionFile(resource, revision);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        return new ResourceRevisionContainer(resource, revision, fileOutputStream, this);
    }

    protected void closeResourceContainer(Resource resource, ResourceRevision resourceRevision, boolean checkForDuplicates, ObjectEnricher objectEnricher) throws IOException, SimilarResourceExistingException {
        List<Resource> resourcesWithSameChecksum;
        File resourceRevisionFile = this.getResourceRevisionFile(resource, resourceRevision);
        String checksum = this.getMD5Checksum(resourceRevisionFile);
        resourceRevision.setChecksum(checksum);
        this.resourceRevisionAccessor.save(resourceRevision);
        resource.setCurrentRevisionId(resourceRevision.getId());
        if (objectEnricher != null) {
            objectEnricher.accept(resource);
        }
        this.resourceAccessor.save(resource);
        if (checkForDuplicates && (resourcesWithSameChecksum = this.getSimilarResources(resource, resourceRevision)).size() > 0) {
            throw new SimilarResourceExistingException(resource, resourcesWithSameChecksum);
        }
    }

    @Override
    public Resource createResource(String resourceType, InputStream resourceStream, String resourceFileName, boolean checkForDuplicates, ObjectEnricher objectEnricher) throws IOException, SimilarResourceExistingException {
        ResourceRevisionContainer resourceContainer = this.createResourceContainer(resourceType, resourceFileName);
        FileHelper.copy((InputStream)resourceStream, (OutputStream)resourceContainer.getOutputStream(), (int)2048);
        resourceContainer.save(checkForDuplicates, objectEnricher);
        return resourceContainer.getResource();
    }

    @Override
    public Resource saveResourceContent(String resourceId, InputStream resourceStream, String resourceFileName) throws IOException {
        Resource resource = this.getResource(resourceId);
        this.createResourceRevisionAndSaveContent(resourceStream, resourceFileName, resource);
        this.updateResourceFileNameIfNecessary(resourceFileName, resource);
        return resource;
    }

    @Override
    public void deleteResource(String resourceId) {
        Resource resource = this.getResource(resourceId);
        this.resourceRevisionAccessor.getResourceRevisionsByResourceId(resourceId).forEachRemaining(revision -> this.resourceRevisionAccessor.remove(revision.getId()));
        File resourceContainer = this.getResourceContainer(resource);
        if (resourceContainer.exists()) {
            FileHelper.deleteFolder((File)resourceContainer);
        }
        this.resourceAccessor.remove(resource.getId());
    }

    private List<Resource> getSimilarResources(Resource actualResource, ResourceRevision actualResourceRevision) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        this.resourceRevisionAccessor.getResourceRevisionsByChecksum(actualResourceRevision.getChecksum()).forEachRemaining(revision -> {
            if (!revision.getId().equals((Object)actualResourceRevision.getId())) {
                Resource resource = (Resource)this.resourceAccessor.get(new ObjectId(revision.getResourceId()));
                if (resource != null) {
                    if (resource.getCurrentRevisionId() != null) {
                        if (resource.getCurrentRevisionId().equals((Object)revision.getId())) {
                            try {
                                if (FileUtils.contentEquals((File)this.getResourceRevisionFile(resource, (ResourceRevision)revision), (File)this.getResourceRevisionFile(actualResource, actualResourceRevision))) {
                                    result.add(resource);
                                }
                            }
                            catch (IOException e) {
                                logger.warn("Error while comparing resource revisions " + revision.getId() + " and " + actualResourceRevision.getId(), (Throwable)e);
                            }
                        }
                    } else {
                        logger.warn("Found resource without current revision: " + resource.getId());
                    }
                } else {
                    logger.warn("Found orphan resource revision: " + revision.getId());
                }
            }
        });
        return result;
    }

    @Override
    public ResourceRevisionContent getResourceContent(String resourceId) throws IOException {
        Resource resource = this.getResource(resourceId);
        ResourceRevision resourceRevision = this.getCurrentResourceRevision(resource);
        return this.getResourceRevisionContent(resource, resourceRevision);
    }

    protected void closeResourceRevisionContent(Resource resource) {
        if (resource.isEphemeral()) {
            this.deleteResource(resource.getId().toString());
        }
    }

    @Override
    public ResourceRevision getResourceRevisionByResourceId(String resourceId) {
        Resource resource = this.getResource(resourceId);
        ResourceRevision resourceRevision = this.getCurrentResourceRevision(resource);
        return resourceRevision;
    }

    @Override
    public ResourceRevisionContentImpl getResourceRevisionContent(String resourceRevisionId) throws IOException {
        ResourceRevision resourceRevision = this.getResourceRevision(new ObjectId(resourceRevisionId));
        Resource resource = this.getResource(resourceRevision.getResourceId());
        return this.getResourceRevisionContent(resource, resourceRevision);
    }

    @Override
    public ResourceRevisionFileHandle getResourceFile(String resourceId) {
        Resource resource = this.getResource(resourceId);
        ResourceRevision resourceRevision = this.getCurrentResourceRevision(resource);
        File resourceRevisionFile = this.getResourceRevisionFile(resource, resourceRevision);
        return new ResourceRevisionFileHandleImpl(this, resource, resourceRevisionFile);
    }

    private ResourceRevisionContentImpl getResourceRevisionContent(Resource resource, ResourceRevision resourceRevision) throws IOException {
        File resourceRevisionFile = this.getResourceRevisionFile(resource, resourceRevision);
        if (!resourceRevisionFile.exists() || !resourceRevisionFile.canRead()) {
            throw new IOException("The resource revision file " + resourceRevisionFile.getAbsolutePath() + " doesn't exist or cannot be read");
        }
        FileInputStream resourceRevisionStream = new FileInputStream(resourceRevisionFile);
        return new ResourceRevisionContentImpl(this, resource, resourceRevisionStream, resourceRevision.getResourceFileName());
    }

    private ResourceRevision getCurrentResourceRevision(Resource resource) {
        return this.getResourceRevision(resource.getCurrentRevisionId());
    }

    private ResourceRevision getResourceRevision(ObjectId resourceRevisionId) {
        ResourceRevision resourceRevision = (ResourceRevision)this.resourceRevisionAccessor.get(resourceRevisionId);
        if (resourceRevision == null) {
            throw new RuntimeException("The resource revision with ID " + resourceRevisionId + " doesn't exist");
        }
        return resourceRevision;
    }

    @Override
    public Resource getResource(String resourceId) {
        Resource resource = (Resource)this.resourceAccessor.get(new ObjectId(resourceId));
        if (resource == null) {
            throw new RuntimeException("The resource with ID " + resourceId + " doesn't exist");
        }
        return resource;
    }

    private File getResourceRevisionFile(Resource resource, ResourceRevision revision) {
        return new File(this.getResourceRevisionContainer(resource, revision).getPath() + "/" + revision.getResourceFileName());
    }

    private File getResourceRevisionContainer(Resource resource, ResourceRevision revision) {
        File containerFile = new File(this.getResourceContainer(resource).getPath() + "/" + revision.getId().toString());
        return containerFile;
    }

    private File getResourceContainer(Resource resource) {
        File containerFile = new File(this.resourceRootFolder + "/" + resource.getResourceType() + "/" + resource.getId().toString());
        return containerFile;
    }

    private File createResourceRevisionContainer(Resource resource, ResourceRevision revision) throws IOException {
        File containerFile = this.getResourceRevisionContainer(resource, revision);
        boolean containerDirectoryCreated = containerFile.mkdirs();
        if (!containerDirectoryCreated) {
            throw new IOException("Unable to create container for resource " + resource.getId() + " in " + containerFile.getAbsolutePath());
        }
        return containerFile;
    }

    private ResourceRevision createResourceRevisionAndSaveContent(InputStream resourceStream, String resourceFileName, Resource resource) throws IOException {
        ResourceRevision revision = this.createResourceRevision(resourceFileName, resource.getId().toString());
        this.createResourceRevisionContainer(resource, revision);
        File resourceFile = this.saveResourceRevisionContent(resourceStream, resource, revision);
        String checksum = this.getMD5Checksum(resourceFile);
        revision.setChecksum(checksum);
        this.resourceRevisionAccessor.save(revision);
        resource.setCurrentRevisionId(revision.getId());
        this.resourceAccessor.save(resource);
        return revision;
    }

    private String getMD5Checksum(File file) throws IOException {
        String hash = com.google.common.io.Files.hash((File)file, (HashFunction)Hashing.md5()).toString();
        return hash;
    }

    private void updateResourceFileNameIfNecessary(String resourceFileName, Resource resource) {
        if (!resource.getResourceName().equals(resourceFileName)) {
            HashMap<String, String> currentAttributes = resource.getAttributes();
            if (currentAttributes == null) {
                currentAttributes = new HashMap<String, String>();
            }
            currentAttributes.put("name", resourceFileName);
            resource.setAttributes(currentAttributes);
            resource.setResourceName(resourceFileName);
            this.resourceAccessor.save(resource);
        }
    }

    private Resource createResource(String resourceTypeId, String name) {
        ResourceType resourceType = this.resourceTypes.get(resourceTypeId);
        if (resourceType == null) {
            throw new RuntimeException("Unknown resource type " + resourceTypeId);
        }
        Resource resource = new Resource();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", name);
        resource.setAttributes(attributes);
        resource.setResourceName(name);
        resource.setResourceType(resourceTypeId);
        resource.setEphemeral(resourceType.isEphemeral());
        return resource;
    }

    private ResourceRevision createResourceRevision(String resourceFileName, String resourceId) {
        ResourceRevision revision = new ResourceRevision();
        revision.setResourceFileName(resourceFileName);
        revision.setResourceId(resourceId);
        return revision;
    }

    private File saveResourceRevisionContent(InputStream resourceStream, Resource resource, ResourceRevision revision) throws IOException {
        File resourceFile = this.getResourceRevisionFile(resource, revision);
        Files.copy(resourceStream, resourceFile.toPath(), new CopyOption[0]);
        return resourceFile;
    }

    @Override
    public Resource lookupResourceByName(String resourceName) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", resourceName);
        return (Resource)this.resourceAccessor.findByAttributes(attributes);
    }

    @Override
    public boolean resourceExists(String resourceId) {
        Resource resource = (Resource)this.resourceAccessor.get(new ObjectId(resourceId));
        return resource != null;
    }

    @Override
    public Resource saveResource(Resource resource) throws IOException {
        return this.resourceAccessor.save(resource);
    }
}

