/*
 * Decompiled with CFR 0.152.
 */
package step.expressions;

import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.expressions.GroovyPoolEntry;
import step.expressions.GroovyPoolFactory;
import step.expressions.GroovyPoolKey;

public class GroovyPool {
    private static final Logger logger = LoggerFactory.getLogger(GroovyPool.class);
    private GenericKeyedObjectPool<GroovyPoolKey, GroovyPoolEntry> pool;

    public GroovyPool(String scriptBaseClass, int poolMaxTotal, int poolMaxIdle) {
        try {
            this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new GroovyPoolFactory(scriptBaseClass));
            this.pool.setTestOnBorrow(true);
            this.pool.setMaxTotal(poolMaxTotal);
            this.pool.setMaxActive(-1);
            this.pool.setMaxIdle(poolMaxIdle);
            this.pool.setWhenExhaustedAction((byte)1);
            this.pool.setTimeBetweenEvictionRunsMillis(30000L);
            this.pool.setMinEvictableIdleTimeMillis(-1L);
        }
        catch (Exception e) {
            logger.error("An error occurred while starting GroovyPool.", (Throwable)e);
        }
    }

    public GroovyPoolEntry borrowShell(String script) throws Exception {
        GroovyPoolKey key = new GroovyPoolKey(script);
        try {
            GroovyPoolEntry entry = (GroovyPoolEntry)this.pool.borrowObject((Object)key);
            return entry;
        }
        catch (Exception e) {
            logger.error("An error occurred while borrowing script: " + script, (Throwable)e);
            throw e;
        }
    }

    public void returnShell(GroovyPoolEntry entry) {
        try {
            this.pool.returnObject((Object)entry.getKey(), (Object)entry);
        }
        catch (Exception e) {
            logger.error("An error occurred while returning script: " + (entry != null && entry.key != null ? entry.key.getScript() : "N/A"), (Throwable)e);
        }
    }
}

