/*
 * Decompiled with CFR 0.152.
 */
package step.expressions;

import groovy.lang.Binding;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.expressions.GroovyPool;
import step.expressions.GroovyPoolEntry;

public class ExpressionHandler {
    private static Logger logger = LoggerFactory.getLogger(ExpressionHandler.class);
    private final GroovyPool groovyPool;
    private final Integer executionTimeWarningTreshold;
    private final String scriptBaseClass;

    public ExpressionHandler() {
        this(null);
    }

    public ExpressionHandler(String scriptBaseClass) {
        this(scriptBaseClass, null, 1000, -1);
    }

    public ExpressionHandler(String scriptBaseClass, Integer executionTimeWarningTreshold, int poolMaxTotal, int poolMaxIdle) {
        this.scriptBaseClass = scriptBaseClass;
        this.groovyPool = new GroovyPool(scriptBaseClass, poolMaxTotal, poolMaxIdle);
        this.executionTimeWarningTreshold = executionTimeWarningTreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateGroovyExpression(String expression, Map<String, Object> bindings) {
        try {
            Object result;
            logger.debug("Groovy evaluation:\n" + expression);
            Binding binding = new Binding();
            if (bindings != null) {
                for (Map.Entry<String, Object> varEntry : bindings.entrySet()) {
                    Object value = varEntry.getValue();
                    binding.setVariable(varEntry.getKey(), value);
                }
            }
            long t1 = System.currentTimeMillis();
            try {
                GroovyPoolEntry entry = this.groovyPool.borrowShell(expression);
                try {
                    Script script = entry.getScript();
                    script.setBinding(binding);
                    result = script.run();
                }
                finally {
                    if (entry != null && entry.getScript() != null) {
                        entry.getScript().setBinding(new Binding());
                    }
                    this.groovyPool.returnShell(entry);
                }
            }
            catch (MultipleCompilationErrorsException e) {
                for (Object error : e.getErrorCollector().getErrors()) {
                    String message;
                    if (!(error instanceof SyntaxErrorMessage) || !(message = ((SyntaxErrorMessage)error).getCause().getMessage()).contains("unable to resolve class") || !message.contains(this.scriptBaseClass)) continue;
                    throw new Exception("Unable to resolve groovy macro class '" + this.scriptBaseClass + "'. Please ensure that the groovy script containing your custom macros is available in the classpath.", e);
                }
                throw e;
            }
            catch (Exception e) {
                logger.error("An error occurred while evaluation groovy expression " + expression, (Throwable)e);
                throw e;
            }
            long duration = System.currentTimeMillis() - t1;
            Integer warnThreshold = this.executionTimeWarningTreshold;
            if (warnThreshold != null && duration > (long)warnThreshold.intValue()) {
                logger.warn("Groovy-Evaluation of following expression took " + duration + ".ms: " + expression);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Groovy-Evaluation of following expression took " + duration + ".ms: " + expression);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Groovy result:\n" + result);
            }
            return result;
        }
        catch (CompilationFailedException cfe) {
            throw new RuntimeException("Error while compiling groovy expression: '" + expression + "'", cfe);
        }
        catch (MissingPropertyException mpe) {
            throw new RuntimeException("Error while resolving groovy properties in expression: '" + expression + "'. The property '" + mpe.getProperty() + "' could not be found (or accessed). Make sure that the property is defined as variable or parameter and accesible in current scope.", mpe);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while running groovy expression: '" + expression + "'", e);
        }
    }
}

