/*
 * Decompiled with CFR 0.152.
 */
package step.core.ql;

import org.antlr.v4.runtime.tree.ParseTree;
import step.core.ql.Filter;
import step.core.ql.FilterFactory;
import step.core.ql.OQLBaseVisitor;
import step.core.ql.OQLParser;

public class OQLFilterVisitor<T>
extends OQLBaseVisitor<Filter<T>> {
    private FilterFactory<T> factory;

    public OQLFilterVisitor(FilterFactory<T> factory) {
        this.factory = factory;
    }

    @Override
    public Filter<T> visitAndExpr(OQLParser.AndExprContext ctx) {
        final Filter left = (Filter)this.visit((ParseTree)ctx.expr(0));
        final Filter right = (Filter)this.visit((ParseTree)ctx.expr(1));
        return new Filter<T>(){

            @Override
            public boolean test(T input) {
                return left.test(input) && right.test(input);
            }
        };
    }

    @Override
    public Filter<T> visitEqualityExpr(OQLParser.EqualityExprContext ctx) {
        String text0 = this.unescapeStringIfNecessary(ctx.expr(0).getText());
        String text1 = this.unescapeStringIfNecessary(ctx.expr(1).getText());
        return this.factory.createAttributeFilter(ctx.op.getText(), text0, text1);
    }

    protected String unescapeStringIfNecessary(String text1) {
        if (text1.startsWith("\"") && text1.endsWith("\"")) {
            text1 = this.unescapeStringAtom(text1);
        }
        return text1;
    }

    @Override
    public Filter<T> visitOrExpr(OQLParser.OrExprContext ctx) {
        final Filter left = (Filter)this.visit((ParseTree)ctx.expr(0));
        final Filter right = (Filter)this.visit((ParseTree)ctx.expr(1));
        return new Filter<T>(){

            @Override
            public boolean test(T input) {
                return left.test(input) || right.test(input);
            }
        };
    }

    @Override
    public Filter<T> visitNotExpr(OQLParser.NotExprContext ctx) {
        final Filter expr = (Filter)this.visit((ParseTree)ctx.expr());
        return new Filter<T>(){

            @Override
            public boolean test(T input) {
                return !expr.test(input);
            }
        };
    }

    @Override
    public Filter<T> visitParExpr(OQLParser.ParExprContext ctx) {
        final Filter expr = (Filter)this.visit((ParseTree)ctx.expr());
        return new Filter<T>(){

            @Override
            public boolean test(T input) {
                return expr.test(input);
            }
        };
    }

    @Override
    public Filter<T> visitNonQuotedStringAtom(OQLParser.NonQuotedStringAtomContext ctx) {
        return this.factory.createFullTextFilter(ctx.getText());
    }

    @Override
    public Filter<T> visitStringAtom(OQLParser.StringAtomContext ctx) {
        String str = this.unescapeStringAtom(ctx.getText());
        return this.factory.createFullTextFilter(str);
    }

    protected String unescapeStringAtom(String str) {
        str = str.substring(1, str.length() - 1).replace("\"\"", "\"");
        return str;
    }
}

