/*
 * Decompiled with CFR 0.152.
 */
package step.core.ql;

import java.lang.reflect.InvocationTargetException;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import step.core.ql.Filter;
import step.core.ql.FilterFactory;
import step.core.ql.OQLFilterVisitor;
import step.core.ql.OQLLexer;
import step.core.ql.OQLParser;

public class OQLFilterBuilder {
    public static Filter<Object> getFilter(String expression) {
        return OQLFilterBuilder.getFilter(expression, new FilterFactory<Object>(){

            @Override
            public Filter<Object> createFullTextFilter(String expression) {
                throw new RuntimeException("Full text search not implemented");
            }

            @Override
            public Filter<Object> createAttributeFilter(String operator, final String attribute, final String value) {
                return new Filter<Object>(){

                    @Override
                    public boolean test(Object input) {
                        try {
                            return value.equals(PropertyUtils.getProperty((Object)input, (String)attribute));
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | NestedNullException e) {
                            return false;
                        }
                    }
                };
            }
        });
    }

    public static <T> Filter<T> getFilter(String expression, FilterFactory<T> factory) {
        if (expression == null || expression.isEmpty()) {
            return new Filter<T>(){

                @Override
                public boolean test(T t) {
                    return true;
                }
            };
        }
        OQLParser.ParseContext context = OQLFilterBuilder.parse(expression);
        OQLFilterVisitor<T> visitor = new OQLFilterVisitor<T>(factory);
        Filter filter = (Filter)visitor.visit(context.getChild(0));
        return filter;
    }

    private static OQLParser.ParseContext parse(String expression) {
        OQLLexer lexer = new OQLLexer((CharStream)new ANTLRInputStream(expression));
        OQLParser parser = new OQLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, (Throwable)e);
            }
        });
        return parser.parse();
    }
}

