/*
 * Decompiled with CFR 0.152.
 */
package step.core.plugins;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.IntStream;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.core.plugins.PluginCallbacks;
import step.core.plugins.exceptions.PluginCriticalException;

public class PluginManager<T extends AbstractPlugin>
implements InvocationHandler {
    private static Logger logger = LoggerFactory.getLogger(PluginManager.class);
    protected List<T> plugins = new CopyOnWriteArrayList<T>();

    public void initialize() throws Exception {
        this.loadAnnotatedPlugins();
    }

    public <CALLBACK extends PluginCallbacks> CALLBACK getProxy(Class<CALLBACK> interfaceClass) {
        PluginCallbacks proxy = (PluginCallbacks)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)this);
        return (CALLBACK)proxy;
    }

    private void loadAnnotatedPlugins() throws InstantiationException, IllegalAccessException, CircularDependencyException {
        Set pluginClasses = new Reflections("step", new Scanner[0]).getTypesAnnotatedWith(Plugin.class);
        logger.debug("Found plugins classes: " + pluginClasses);
        for (Class pluginClass : pluginClasses) {
            T plugin = this.newPluginInstance(pluginClass);
            if (!((AbstractPlugin)plugin).validate()) continue;
            this.register(plugin);
        }
        this.plugins = this.sortPluginsByDependencies(this.plugins);
        logger.info("Loaded plugins in following order: " + this.plugins);
    }

    protected List<T> sortPluginsByDependencies(List<T> plugins) throws CircularDependencyException {
        HashMap<Class, List> additionalDependencies = new HashMap<Class, List>();
        for (AbstractPlugin plugin : plugins) {
            Class<?> pluginClass = plugin.getClass();
            Class<? extends AbstractPlugin>[] runsBeforeList = pluginClass.getAnnotation(Plugin.class).runsBefore();
            for (Class<? extends AbstractPlugin> runsBefore : runsBeforeList) {
                additionalDependencies.computeIfAbsent(runsBefore, c -> new ArrayList()).add(pluginClass);
            }
        }
        ArrayList<T> result = new ArrayList<T>(plugins);
        int iterationCount = 0;
        boolean hasModification = true;
        while (hasModification) {
            if (iterationCount > 1000) {
                throw new CircularDependencyException("Circular dependency in the plugin dependencies");
            }
            hasModification = false;
            ArrayList<T> clone = new ArrayList<T>(result);
            for (AbstractPlugin plugin : result) {
                Class<?> pluginClass = plugin.getClass();
                Class<? extends AbstractPlugin>[] dependencies = pluginClass.getAnnotation(Plugin.class).dependencies();
                ArrayList<Class<? extends AbstractPlugin>> allDependencies = new ArrayList<Class<? extends AbstractPlugin>>(Arrays.asList(dependencies));
                if (additionalDependencies.containsKey(pluginClass)) {
                    allDependencies.addAll((Collection)additionalDependencies.get(pluginClass));
                }
                int initialPosition = clone.indexOf(plugin);
                int newPosition = -1;
                if (allDependencies.size() > 0) {
                    for (Class clazz : allDependencies) {
                        int positionOfDependencyInClone = IntStream.range(0, clone.size()).filter(i -> dependency.equals(((AbstractPlugin)clone.get(i)).getClass())).findFirst().orElse(-1);
                        if (positionOfDependencyInClone <= initialPosition || positionOfDependencyInClone <= newPosition) continue;
                        newPosition = positionOfDependencyInClone;
                    }
                }
                if (newPosition < 0) continue;
                clone.add(newPosition + 1, plugin);
                clone.remove(initialPosition);
                hasModification = true;
            }
            result = clone;
            ++iterationCount;
        }
        return result;
    }

    public void register(T plugin) {
        this.plugins.add(plugin);
    }

    private T newPluginInstance(Class<T> _class) throws InstantiationException, IllegalAccessException {
        AbstractPlugin plugin = (AbstractPlugin)_class.newInstance();
        return (T)plugin;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (AbstractPlugin plugin : this.plugins) {
            try {
                method.invoke((Object)plugin, args);
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof PluginCriticalException) {
                    throw ((InvocationTargetException)e).getTargetException();
                }
                logger.error("Error invoking method #" + method.getName() + " of plugin '" + plugin.getClass().getName() + "'(" + e.toString() + ")", e);
            }
        }
        return null;
    }

    public static class CircularDependencyException
    extends Exception {
        public CircularDependencyException(String message) {
            super(message);
        }
    }
}

