/*
 * Decompiled with CFR 0.152.
 */
package step.core.artefacts.reports;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import step.attachments.AttachmentMeta;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.reports.Error;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="_class")
public class ReportNode
extends AbstractIdentifiableObject {
    protected ObjectId parentID;
    protected String name;
    protected String executionID;
    protected ObjectId artefactID;
    protected long executionTime;
    protected Integer duration;
    protected List<AttachmentMeta> attachments = new ArrayList<AttachmentMeta>();
    protected ReportNodeStatus status;
    protected Error error;
    protected Map<String, String> customAttributes;
    @JsonIgnore
    protected AbstractArtefact artefactInstance;
    protected AbstractArtefact resolvedArtefact;

    public ObjectId getParentID() {
        return this.parentID;
    }

    public void setParentID(ObjectId parentID) {
        this.parentID = parentID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getExecutionID() {
        return this.executionID;
    }

    public void setExecutionID(String executionID) {
        this.executionID = executionID;
    }

    public ObjectId getArtefactID() {
        return this.artefactID;
    }

    public void setArtefactID(ObjectId artefactID) {
        this.artefactID = artefactID;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public List<AttachmentMeta> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<AttachmentMeta> attachments) {
        this.attachments = attachments;
    }

    public ReportNodeStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReportNodeStatus status) {
        this.status = status;
    }

    public Error getError() {
        return this.error;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public AbstractArtefact getResolvedArtefact() {
        return this.resolvedArtefact;
    }

    public void setResolvedArtefact(AbstractArtefact resolvedArtefact) {
        this.resolvedArtefact = resolvedArtefact;
    }

    public boolean persistNode() {
        return this.resolvedArtefact == null || this.resolvedArtefact.isPersistNode();
    }

    public void setError(String errorMessage, int errorCode, boolean isRoot) {
        Error errorObject = new Error();
        errorObject.setMsg(errorMessage);
        errorObject.setRoot(isRoot);
        errorObject.setCode(Integer.valueOf(0));
        this.error = errorObject;
    }

    public void addError(String error) {
        if (error != null) {
            if (this.error != null) {
                this.getError().setMsg(this.getError().getMsg() + "\n" + error);
            } else {
                this.setError(error, 0, true);
            }
        }
    }

    public void addAttachment(AttachmentMeta attachment) {
        this.attachments.add(attachment);
    }

    public String getCustomAttribute(String key) {
        if (this.customAttributes != null) {
            return this.customAttributes.get(key);
        }
        return null;
    }

    public synchronized void addCustomAttribute(String key, String value) {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, String>();
        }
        this.customAttributes.put(key, value);
    }

    public AbstractArtefact getArtefactInstance() {
        return this.artefactInstance;
    }

    public void setArtefactInstance(AbstractArtefact artefactInstance) {
        this.artefactInstance = artefactInstance;
    }
}

