/*
 * Decompiled with CFR 0.152.
 */
package step.core.artefacts;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.Artefact;

public class ArtefactRegistry {
    private static ArtefactRegistry instance;
    Map<String, Class<? extends AbstractArtefact>> register = new HashMap<String, Class<? extends AbstractArtefact>>();

    public static synchronized ArtefactRegistry getInstance() {
        if (instance == null) {
            instance = new ArtefactRegistry();
            Set artefacts = new Reflections("step.artefacts", new Scanner[0]).getTypesAnnotatedWith(Artefact.class);
            for (Class artfefactClass : artefacts) {
                instance.register(artfefactClass);
            }
        }
        return instance;
    }

    public void register(Class<? extends AbstractArtefact> artefact) {
        this.register.put(ArtefactRegistry.getArtefactName(artefact), artefact);
    }

    public Set<String> getArtefactNames() {
        return this.register.keySet();
    }

    public Class<? extends AbstractArtefact> getArtefactType(String name) {
        return this.register.get(name);
    }

    public AbstractArtefact getArtefactTypeInstance(String type) throws Exception {
        Class<? extends AbstractArtefact> clazz = ArtefactRegistry.getInstance().getArtefactType(type);
        AbstractArtefact sample = clazz.newInstance();
        for (Method m : clazz.getMethods()) {
            if (m.getAnnotation(PostConstruct.class) == null) continue;
            m.invoke((Object)sample, new Object[0]);
        }
        return sample;
    }

    public static String getArtefactName(Class<? extends AbstractArtefact> artefactClass) {
        Artefact annotation = artefactClass.getAnnotation(Artefact.class);
        return annotation.name().length() > 0 ? annotation.name() : artefactClass.getSimpleName();
    }
}

