/*
 * Decompiled with CFR 0.152.
 */
package step.core.artefacts;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractOrganizableObject;
import step.core.accessors.MapDeserializer;
import step.core.accessors.MapSerializer;
import step.core.artefacts.Artefact;
import step.core.artefacts.ArtefactTypeIdResolver;
import step.core.dynamicbeans.DynamicValue;

@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, property="_class")
@JsonTypeIdResolver(value=ArtefactTypeIdResolver.class)
public abstract class AbstractArtefact
extends AbstractOrganizableObject {
    protected String description;
    protected List<AbstractArtefact> children = new ArrayList<AbstractArtefact>();
    @JsonSerialize(using=MapSerializer.class)
    @JsonDeserialize(using=MapDeserializer.class)
    protected Map<String, Object> customAttributes;
    protected List<ObjectId> attachments;
    protected boolean persistNode = true;
    private DynamicValue<Boolean> skipNode = new DynamicValue((Object)false);

    public AbstractArtefact() {
        this._id = new ObjectId();
        HashMap<String, String> defaultAttributes = new HashMap<String, String>();
        defaultAttributes.put("name", this.getDefaultArtefactName(((Object)((Object)this)).getClass()));
        this.attributes = defaultAttributes;
        this.persistNode = true;
    }

    private String getDefaultArtefactName(Class<? extends AbstractArtefact> artefactClass) {
        Artefact annotation = artefactClass.getAnnotation(Artefact.class);
        return annotation.name().length() > 0 ? annotation.name() : artefactClass.getSimpleName();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<AbstractArtefact> getChildren() {
        return this.children;
    }

    public void setChildren(List<AbstractArtefact> children) {
        this.children = children;
    }

    public boolean addChild(AbstractArtefact e) {
        return this.children.add(e);
    }

    public Map<String, Object> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(Map<String, Object> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public Object getCustomAttribute(String key) {
        if (this.customAttributes != null) {
            return this.customAttributes.get(key);
        }
        return null;
    }

    public synchronized void addCustomAttribute(String key, Object value) {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, Object>();
        }
        this.customAttributes.put(key, value);
    }

    public void addAttachment(ObjectId attachmentId) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<ObjectId>();
        }
        this.attachments.add(attachmentId);
    }

    public void setAttachments(List<ObjectId> attachments) {
        this.attachments = attachments;
    }

    public List<ObjectId> getAttachments() {
        return this.attachments;
    }

    @JsonIgnore
    public boolean isCreateSkeleton() {
        return false;
    }

    public boolean isPersistNode() {
        return this.persistNode;
    }

    public void setPersistNode(boolean persistNode) {
        this.persistNode = persistNode;
    }

    public DynamicValue<Boolean> getSkipNode() {
        return this.skipNode;
    }

    public void setSkipNode(DynamicValue<Boolean> skipNode) {
        this.skipNode = skipNode;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._id == null ? 0 : this._id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractArtefact other = (AbstractArtefact)((Object)obj);
        return !(this._id == null ? other._id != null : !this._id.equals((Object)other._id));
    }
}

