/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.AbstractOrganizableObject;
import step.core.accessors.CRUDAccessor;

public class InMemoryCRUDAccessor<T extends AbstractIdentifiableObject>
implements CRUDAccessor<T> {
    protected Map<ObjectId, T> map = new ConcurrentHashMap<ObjectId, T>();

    @Override
    public T get(ObjectId id) {
        return (T)((AbstractIdentifiableObject)this.map.get(id));
    }

    @Override
    public T get(String id) {
        return this.get(new ObjectId(id));
    }

    @Override
    public T findByAttributes(Map<String, String> attributes) {
        return (T)((AbstractIdentifiableObject)this.map.values().stream().filter(v -> {
            if (v instanceof AbstractOrganizableObject) {
                return ((AbstractOrganizableObject)v).attributes.equals(attributes);
            }
            if (v instanceof AbstractIdentifiableObject) {
                return v.customFields.equals(attributes);
            }
            return false;
        }).findFirst().orElse(null));
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        return this.map.values().stream().filter(v -> {
            if (v instanceof AbstractOrganizableObject) {
                return ((AbstractOrganizableObject)v).attributes.equals(attributes);
            }
            if (v instanceof AbstractIdentifiableObject) {
                return v.customFields.equals(attributes);
            }
            return false;
        }).spliterator();
    }

    @Override
    public Iterator<T> getAll() {
        return this.map.values().iterator();
    }

    @Override
    public void remove(ObjectId id) {
        this.map.remove(id);
    }

    @Override
    public T save(T entity) {
        if (entity.getId() == null) {
            entity.setId(new ObjectId());
        }
        this.map.put(entity.getId(), entity);
        return entity;
    }

    @Override
    public void save(Collection<? extends T> entities) {
        entities.forEach(e -> this.save(e));
    }

    @Override
    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return (T)((AbstractIdentifiableObject)this.map.values().stream().filter(v -> {
            if (attributesMapKey.equals("attributes")) {
                return ((AbstractOrganizableObject)v).attributes.equals(attributes);
            }
            if (attributesMapKey.equals("customFields")) {
                return v.customFields.equals(attributes);
            }
            return false;
        }).findFirst().orElse(null));
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.map.values().stream().filter(v -> {
            if (v instanceof AbstractOrganizableObject) {
                return ((AbstractOrganizableObject)v).attributes.equals(attributes);
            }
            if (attributesMapKey.equals("customFields")) {
                return v.customFields.equals(attributes);
            }
            return false;
        }).spliterator();
    }

    @Override
    public List<T> getRange(int skip, int limit) {
        ArrayList<T> list = new ArrayList<T>(this.map.values());
        if (skip < list.size()) {
            return list.subList(skip, Math.min(list.size(), skip + limit));
        }
        return new ArrayList();
    }
}

