/*
 * Decompiled with CFR 0.152.
 */
package step.resources;

import java.io.IOException;
import java.io.OutputStream;
import step.resources.Resource;
import step.resources.ResourceManagerImpl;
import step.resources.ResourceRevision;
import step.resources.SimilarResourceExistingException;

public class ResourceRevisionContainer {
    protected final Resource resource;
    protected final ResourceRevision resourceRevision;
    protected final OutputStream outputStream;
    private final ResourceManagerImpl resourceManagerImpl;

    protected ResourceRevisionContainer(Resource resource, ResourceRevision resourceRevision, OutputStream outputStream, ResourceManagerImpl resourceManagerImpl) {
        this.resource = resource;
        this.resourceRevision = resourceRevision;
        this.outputStream = outputStream;
        this.resourceManagerImpl = resourceManagerImpl;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Resource getResource() {
        return this.resource;
    }

    public ResourceRevision getResourceRevision() {
        return this.resourceRevision;
    }

    public void save(boolean checkForDuplicates) throws IOException, SimilarResourceExistingException {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.resourceManagerImpl.closeResourceContainer(this.resource, this.resourceRevision, checkForDuplicates);
    }

    public void save() throws IOException {
        try {
            this.save(false);
        }
        catch (SimilarResourceExistingException e) {
            throw new RuntimeException("This should never happen");
        }
    }
}

