/*
 * Decompiled with CFR 0.152.
 */
package step.expressions;

import groovy.lang.Binding;
import groovy.lang.Script;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.commons.conf.Configuration;
import step.expressions.GroovyPool;
import step.expressions.GroovyPoolEntry;

public class ExpressionHandler {
    private static Logger logger = LoggerFactory.getLogger(ExpressionHandler.class);
    private final GroovyPool groovyPool;

    public ExpressionHandler() {
        this(null);
    }

    public ExpressionHandler(String scriptBaseClass) {
        this.groovyPool = new GroovyPool(scriptBaseClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluateGroovyExpression(String expression, Map<String, Object> bindings) {
        try {
            Object result;
            logger.debug("Groovy evaluation:\n" + expression);
            Binding binding = new Binding();
            if (bindings != null) {
                for (Map.Entry<String, Object> varEntry : bindings.entrySet()) {
                    Object value = varEntry.getValue();
                    binding.setVariable(varEntry.getKey(), value);
                }
            }
            long t1 = System.currentTimeMillis();
            try {
                GroovyPoolEntry entry = this.groovyPool.borrowShell(expression);
                try {
                    Script script = entry.getScript();
                    script.setBinding(binding);
                    result = script.run();
                }
                finally {
                    if (entry != null && entry.getScript() != null) {
                        entry.getScript().setBinding(new Binding());
                    }
                    this.groovyPool.returnShell(entry);
                }
            }
            catch (Exception e) {
                logger.error("An error occurred while evaluation groovy expression " + expression, (Throwable)e);
                throw e;
            }
            long duration = System.currentTimeMillis() - t1;
            Integer warnThreshold = Configuration.getInstance().getPropertyAsInteger("tec.expressions.warningthreshold");
            if (warnThreshold != null && duration > (long)warnThreshold.intValue()) {
                logger.warn("Groovy-Evaluation of following expression took " + duration + ".ms: " + expression);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Groovy-Evaluation of following expression took " + duration + ".ms: " + expression);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Groovy result:\n" + result);
            }
            return result;
        }
        catch (CompilationFailedException cfe) {
            throw new RuntimeException("Error in while compilating groovy expression: " + expression, cfe);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in while running groovy expression: " + expression, e);
        }
    }
}

