/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.AbstractOrganizableObject;
import step.core.accessors.CRUDAccessor;

public class InMemoryCRUDAccessor<T extends AbstractIdentifiableObject>
implements CRUDAccessor<T> {
    protected Map<ObjectId, T> map = new ConcurrentHashMap<ObjectId, T>();

    @Override
    public T get(ObjectId id) {
        return (T)((AbstractIdentifiableObject)this.map.get(id));
    }

    @Override
    public T findByAttributes(Map<String, String> attributes) {
        return (T)((AbstractIdentifiableObject)this.map.values().stream().filter(v -> {
            if (v instanceof AbstractOrganizableObject) {
                return ((AbstractOrganizableObject)v).attributes.equals(attributes);
            }
            return false;
        }).findFirst().orElse(null));
    }

    @Override
    public Iterator<T> getAll() {
        return this.map.values().iterator();
    }

    @Override
    public void remove(ObjectId id) {
        this.map.remove(id);
    }

    @Override
    public T save(T entity) {
        if (entity.getId() == null) {
            entity.setId(new ObjectId());
        }
        return (T)((AbstractIdentifiableObject)this.map.put(entity.getId(), entity));
    }

    @Override
    public void save(List<? extends T> entities) {
        entities.forEach(e -> this.save(e));
    }
}

