/*
 * Decompiled with CFR 0.152.
 */
package step.repositories.staging;

import ch.exense.commons.io.FileHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import step.core.GlobalContext;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.plans.Plan;
import step.core.repositories.RepositoryObjectReference;
import step.repositories.staging.StagingContext;
import step.repositories.staging.StagingContextAccessorImpl;
import step.resources.ResourceManager;
import step.resources.ResourceRevisionContainer;

@Singleton
@Path(value="staging")
public class StagingRepositoryServices
extends AbstractServices {
    protected StagingContextAccessorImpl stagingContextAccessor;
    protected ResourceManager resourceManager;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        GlobalContext context = this.getContext();
        this.stagingContextAccessor = (StagingContextAccessorImpl)context.get(StagingContextAccessorImpl.class);
        this.resourceManager = (ResourceManager)context.get(ResourceManager.class);
    }

    @GET
    @Path(value="/context")
    @Consumes(value={"application/json"})
    @Secured(right="plan-write")
    public String createContext() {
        StagingContext context = new StagingContext();
        this.stagingContextAccessor.save(context);
        return context.getId().toString();
    }

    @POST
    @Path(value="/context/{id}/plan")
    @Consumes(value={"application/json"})
    @Secured(right="plan-write")
    public void uploadPlan(@PathParam(value="id") String id, Plan plan) {
        StagingContext context = (StagingContext)((Object)this.stagingContextAccessor.get(id));
        context.setPlan(plan);
        this.stagingContextAccessor.save(context);
    }

    @POST
    @Path(value="/context/{id}/file")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String uploadFile(@PathParam(value="id") String id, @FormDataParam(value="file") InputStream uploadedInputStream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) throws IOException {
        StagingContext context = (StagingContext)((Object)this.stagingContextAccessor.get(id));
        if (uploadedInputStream == null || fileDetail == null) {
            throw new RuntimeException("Invalid arguments");
        }
        ResourceRevisionContainer container = this.resourceManager.createResourceContainer("stagingContextFiles", fileDetail.getFileName());
        try {
            FileHelper.copy((InputStream)uploadedInputStream, (OutputStream)container.getOutputStream(), (int)2048);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while saving file.");
        }
        finally {
            container.save();
        }
        String resourceId = container.getResource().getId().toString();
        context.addAttachment(resourceId);
        this.stagingContextAccessor.save(context);
        return resourceId;
    }

    @POST
    @Path(value="/context/{id}/execute")
    @Consumes(value={"application/json"})
    @Secured(right="plan-write")
    public String execute(@PathParam(value="id") String id, Map<String, String> executionParameters, @QueryParam(value="isolate") boolean isolate) {
        StagingContext context = (StagingContext)((Object)this.stagingContextAccessor.get(id));
        ExecutionParameters params = new ExecutionParameters();
        HashMap<String, String> repositoryParameters = new HashMap<String, String>();
        repositoryParameters.put("contextid", id);
        params.setArtefact(new RepositoryObjectReference("staging", repositoryParameters));
        params.setMode(ExecutionMode.RUN);
        params.setDescription((String)context.plan.getRoot().getAttributes().get("name"));
        params.setIsolatedExecution(Boolean.valueOf(isolate));
        params.setUserID("remote");
        params.setCustomParameters(executionParameters);
        return this.controller.getScheduler().execute(params);
    }

    @POST
    @Path(value="/context/{id}/destroy")
    @Consumes(value={"application/json"})
    @Secured(right="plan-write")
    public void destroy(@PathParam(value="id") String id) {
        StagingContext context = (StagingContext)((Object)this.stagingContextAccessor.get(id));
        context.getAttachments().forEach(resourceId -> this.resourceManager.deleteResource(resourceId));
    }
}

