/*
 * Decompiled with CFR 0.152.
 */
package step.core.export;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.deployment.JacksonMapperProvider;

public class ExportManager {
    private static final Logger logger = LoggerFactory.getLogger(ExportManager.class);
    ArtefactAccessor accessor;

    public ExportManager(ArtefactAccessor accessor) {
        this.accessor = accessor;
    }

    public void exportArtefactWithChildren(String artefactId, OutputStream outputStream) throws FileNotFoundException, IOException {
        ObjectMapper mapper = this.getMapper();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            this.exportArtefactRecursive(mapper, writer, new ObjectId(artefactId));
        }
        catch (Exception e) {
            logger.error("Error while exporting artefact with id " + artefactId, (Throwable)e);
        }
    }

    private ObjectMapper getMapper() {
        ObjectMapper mapper = JacksonMapperProvider.createMapper();
        mapper.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return mapper;
    }

    public void exportAllArtefacts(OutputStream outputStream) throws FileNotFoundException, IOException {
        ObjectMapper mapper = this.getMapper();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream));){
            this.accessor.getRootArtefacts().forEachRemaining(a -> {
                try {
                    this.exportArtefactRecursive(mapper, writer, new ObjectId(a.getId().toString()));
                }
                catch (Exception e) {
                    logger.error("Error while exporting artfact " + a.getId().toString(), (Throwable)e);
                }
            });
        }
    }

    private void exportArtefactRecursive(ObjectMapper mapper, Writer writer, ObjectId id) throws IOException {
        AbstractArtefact artefact = (AbstractArtefact)this.accessor.get(id);
        mapper.writeValue(writer, (Object)artefact);
        writer.write("\n");
        if (artefact.getChildrenIDs() != null) {
            for (ObjectId childId : artefact.getChildrenIDs()) {
                this.exportArtefactRecursive(mapper, writer, childId);
            }
        }
    }
}

