/*
 * Decompiled with CFR 0.152.
 */
package step.core.execution.model;

import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jongo.MongoCursor;
import step.commons.iterators.SkipLimitIterator;
import step.commons.iterators.SkipLimitProvider;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.MongoClientSession;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionAccessor;
import step.core.repositories.RepositoryObjectReference;

public class ExecutionAccessorImpl
extends AbstractCRUDAccessor<Execution>
implements ExecutionAccessor {
    MongoCollection<Document> executions_;

    public ExecutionAccessorImpl(MongoClientSession clientSession) {
        super(clientSession, "executions", Execution.class);
        this.executions_ = clientSession.getMongoDatabase().getCollection("executions");
    }

    public void createIndexesIfNeeded(Long ttl) {
        ExecutionAccessorImpl.createOrUpdateIndex(this.executions_, "startTime");
        ExecutionAccessorImpl.createOrUpdateIndex(this.executions_, "description");
        ExecutionAccessorImpl.createOrUpdateIndex(this.executions_, "executionParameters.userID");
        ExecutionAccessorImpl.createOrUpdateIndex(this.executions_, "executionTaskID");
    }

    @Override
    public Execution get(String nodeId) {
        return (Execution)this.get(new ObjectId(nodeId));
    }

    public List<Execution> getActiveTests() {
        ArrayList<Execution> result = new ArrayList<Execution>();
        for (Execution execution : this.collection.find("{status: { $ne: 'ENDED' }}").as(Execution.class)) {
            result.add(execution);
        }
        return result;
    }

    public List<Execution> getTestExecutionsByArtefactURL(RepositoryObjectReference objectReference) {
        ArrayList<Execution> result = new ArrayList<Execution>();
        this.collection.find("{executionParameters.artefact: #}", new Object[]{objectReference}).as(Execution.class).forEach(e -> result.add((Execution)e));
        return result;
    }

    public List<Execution> findByCritera(Map<String, String> criteria, long start, long end, int skip, int limit) {
        String critSeparator = ", ";
        String fieldSeparator = " : ";
        StringBuilder query = new StringBuilder();
        query.append("{");
        for (Map.Entry<String, String> e : criteria.entrySet()) {
            query.append(e.getKey());
            query.append(fieldSeparator);
            query.append("#");
            query.append(critSeparator);
        }
        query.append("startTime");
        query.append(fieldSeparator);
        query.append("{ $gte" + fieldSeparator + start + "}");
        query.append(critSeparator);
        query.append("endTime");
        query.append(fieldSeparator);
        query.append("{ $lte" + fieldSeparator + end + "}");
        query.append("}");
        ArrayList<Execution> res = new ArrayList<Execution>();
        MongoCursor curs = this.collection.find(query.toString(), criteria.values().toArray()).sort("{ \"endTime\" : -1}").skip(skip).limit(limit).as(Execution.class);
        curs.forEach(val -> res.add((Execution)val));
        return res;
    }

    public Iterable<Execution> findByCritera(final Map<String, String> criteria, final Date start, final Date end) {
        return new Iterable<Execution>(){

            @Override
            public Iterator<Execution> iterator() {
                return new SkipLimitIterator((SkipLimitProvider)new SkipLimitProvider<Execution>(){

                    public List<Execution> getBatch(int skip, int limit) {
                        return ExecutionAccessorImpl.this.findByCritera(criteria, start.getTime(), end.getTime(), skip, limit);
                    }
                });
            }
        };
    }

    public Iterable<Execution> findLastStarted(int limit) {
        String sort = "{ startTime: -1}";
        return this.collection.find().sort(sort).limit(limit).as(Execution.class);
    }

    public Iterable<Execution> findLastEnded(int limit) {
        String sort = "{ endTime: -1}";
        return this.collection.find().sort(sort).limit(limit).as(Execution.class);
    }

    public List<Execution> getLastExecutionsBySchedulerTaskID(String schedulerTaskID, int limit) {
        ArrayList<Execution> result = new ArrayList<Execution>();
        this.collection.find("{executionTaskID: #, status: { $eq: 'ENDED' }}", new Object[]{schedulerTaskID}).sort("{ endTime: -1}").limit(limit).as(Execution.class).forEach(e -> result.add((Execution)e));
        return result;
    }
}

