/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import javax.annotation.PostConstruct;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import step.core.controller.ControllerSetting;
import step.core.controller.ControllerSettingAccessor;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;

@Singleton
@Path(value="settings")
public class SettingsServices
extends AbstractServices {
    protected ControllerSettingAccessor controllerSettingsAccessor;

    @Override
    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.controllerSettingsAccessor = new ControllerSettingAccessor(this.controller.getContext().getMongoClientSession());
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}")
    @Secured(right="admin")
    public void save(@PathParam(value="id") String key, String value) {
        ControllerSetting setting = this.controllerSettingsAccessor.getSettingByKey(key);
        if (setting == null) {
            setting = new ControllerSetting();
            setting.setKey(key);
        }
        setting.setValue(value);
        this.controllerSettingsAccessor.save(setting);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"text/plain"})
    @Secured(right="admin")
    public String get(@PathParam(value="id") String key) {
        ControllerSetting setting = this.controllerSettingsAccessor.getSettingByKey(key);
        if (setting != null) {
            return setting.getValue();
        }
        return null;
    }
}

