/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import ch.exense.commons.app.Configuration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.ext.ReaderInterceptorContext;
import javax.ws.rs.ext.WriterInterceptorContext;
import step.core.Controller;
import step.core.GlobalContext;
import step.core.deployment.Session;
import step.core.execution.ExecutionRunnable;
import step.core.scheduler.ExecutionScheduler;

public abstract class AbstractServices {
    private static final String SESSION = "session";
    @Inject
    protected Controller controller;
    protected Configuration configuration;

    @PostConstruct
    public void init() throws Exception {
        this.configuration = this.controller.getContext().getConfiguration();
    }

    protected GlobalContext getContext() {
        return this.controller.getContext();
    }

    ExecutionScheduler getScheduler() {
        return this.controller.getScheduler();
    }

    protected ExecutionRunnable getExecutionRunnable(String executionID) {
        for (ExecutionRunnable runnable : this.getScheduler().getCurrentExecutions()) {
            if (!runnable.getContext().getExecutionId().equals(executionID)) continue;
            return runnable;
        }
        return null;
    }

    protected Session getSession(ContainerRequestContext crc) {
        Session session = (Session)((Object)crc.getProperty(SESSION));
        return session;
    }

    protected Session getSession(ReaderInterceptorContext crc) {
        Session session = (Session)((Object)crc.getProperty(SESSION));
        return session;
    }

    protected Session getSession(WriterInterceptorContext crc) {
        Session session = (Session)((Object)crc.getProperty(SESSION));
        return session;
    }
}

