/*
 * Decompiled with CFR 0.152.
 */
package step.core.artefacts;

import java.util.Iterator;
import java.util.Map;
import javax.json.JsonObjectBuilder;
import javax.json.spi.JsonProvider;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractCRUDAccessor;
import step.core.accessors.MongoClientSession;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.WorkArtefactFactory;

public class ArtefactAccessorImpl
extends AbstractCRUDAccessor<AbstractArtefact>
implements ArtefactAccessor {
    private WorkArtefactFactory workArtefactFactory = new WorkArtefactFactory();
    private static final JsonProvider jsonProvider = JsonProvider.provider();

    public ArtefactAccessorImpl(MongoClientSession clientSession) {
        super(clientSession, "artefacts", AbstractArtefact.class);
    }

    public <T extends AbstractArtefact> T createWorkArtefact(Class<T> artefactClass, AbstractArtefact parentArtefact, String name) {
        return (T)this.workArtefactFactory.createWorkArtefact(artefactClass, parentArtefact, name, false);
    }

    public <T extends AbstractArtefact> T createWorkArtefact(Class<T> artefactClass, AbstractArtefact parentArtefact, String name, boolean copyChildren) {
        return (T)this.workArtefactFactory.createWorkArtefact(artefactClass, parentArtefact, name, copyChildren);
    }

    @Override
    public AbstractArtefact findByAttributes(Map<String, String> attributes) {
        return this.findByAttributes(attributes, false);
    }

    public AbstractArtefact findRootArtefactByAttributes(Map<String, String> attributes) {
        return this.findByAttributes(attributes, true);
    }

    protected AbstractArtefact findByAttributes(Map<String, String> attributes, boolean rootOnly) {
        JsonObjectBuilder builder = jsonProvider.createObjectBuilder();
        for (String key : attributes.keySet()) {
            builder.add("attributes." + key, attributes.get(key));
        }
        if (rootOnly) {
            builder.add("root", true);
        }
        String query = builder.build().toString();
        return (AbstractArtefact)this.collection.findOne(query).as(AbstractArtefact.class);
    }

    @Override
    public AbstractArtefact get(String artefactID) {
        return (AbstractArtefact)this.get(new ObjectId(artefactID));
    }

    public Iterator<AbstractArtefact> getRootArtefacts() {
        JsonObjectBuilder builder = jsonProvider.createObjectBuilder();
        builder.add("root", true);
        return this.collection.find(builder.build().toString()).as(AbstractArtefact.class);
    }

    public Iterator<AbstractArtefact> getChildren(AbstractArtefact parent) {
        final Iterator childrenIdIt = parent.getChildrenIDs() != null ? parent.getChildrenIDs().iterator() : null;
        Iterator<AbstractArtefact> childrenIt = new Iterator<AbstractArtefact>(){

            @Override
            public void remove() {
            }

            @Override
            public AbstractArtefact next() {
                return (AbstractArtefact)ArtefactAccessorImpl.this.get((ObjectId)childrenIdIt.next());
            }

            @Override
            public boolean hasNext() {
                return childrenIdIt != null ? childrenIdIt.hasNext() : false;
            }
        };
        return childrenIt;
    }
}

