/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.CountOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bson.Document;
import org.bson.conversions.Bson;
import step.core.accessors.CollectionFind;
import step.core.accessors.SearchOrder;

public class Collection {
    protected MongoCollection<Document> collection;
    private static final int DEFAULT_LIMIT = 1000;

    public Collection(MongoDatabase mongoDatabase, String collectionName) {
        this.collection = mongoDatabase.getCollection(collectionName);
    }

    public List<String> distinct(String key) {
        return (List)this.collection.distinct(key, String.class).filter((Bson)new Document(key, (Object)new Document("$ne", null))).into(new ArrayList());
    }

    public CollectionFind<Document> find(Bson query, SearchOrder order, Integer skip, Integer limit) {
        long count = this.collection.count();
        CountOptions option = new CountOptions();
        option.skip(0).limit(1000);
        long countResults = this.collection.count(query, option);
        FindIterable find = this.collection.find(query);
        if (order != null) {
            Document sortDoc = new Document(order.getAttributeName(), (Object)order.getOrder());
            find.sort((Bson)sortDoc);
        }
        if (skip != null) {
            find.skip(skip.intValue());
        }
        if (limit != null) {
            find.limit(limit.intValue());
        }
        return new CollectionFind<Document>(count, countResults, (Iterator<Document>)find.iterator());
    }
}

