/*
 * Decompiled with CFR 0.152.
 */
package step.expressions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import junit.framework.Assert;
import org.junit.Test;
import step.expressions.ExpressionHandler;

public class ExpressionHandlerTest {
    @Test
    public void testDefault() {
        ExpressionHandler e = new ExpressionHandler();
        Object o = e.evaluateGroovyExpression("1+1", null);
        Assert.assertEquals((Object)2, (Object)o);
    }

    @Test
    public void testBindings() {
        ExpressionHandler e = new ExpressionHandler("step.expressions.GroovyFunctions");
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("test", "value");
        Object o = e.evaluateGroovyExpression("test", b);
        Assert.assertEquals((String)"value", (String)o.toString());
    }

    @Test
    public void testScriptBaseClass() {
        ExpressionHandler e = new ExpressionHandler("step.expressions.GroovyFunctions");
        Object o = e.evaluateGroovyExpression("yyyyMMdd", null);
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        Assert.assertEquals((String)f.format(new Date()), (String)o.toString());
    }

    @Test
    public void testScriptBaseClassWithArrays() {
        ExpressionHandler e = new ExpressionHandler("step.expressions.GroovyTestFunctions");
        Object o = e.evaluateGroovyExpression("\"${testArrays()[0]}\"", null);
        Assert.assertEquals((String)"foo", (String)o.toString());
    }
}

