/*
 * Decompiled with CFR 0.152.
 */
package step.core.plans.builder;

import org.junit.Assert;
import org.junit.Test;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.Artefact;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.ExecutionContext;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;

public class PlanBuilderTest {
    @Test
    public void testNoRoot() {
        Exception ex = null;
        try {
            PlanBuilder.create().add(PlanBuilderTest.artefact("Root"));
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertEquals((Object)"No root artefact defined. Please first call the method startBlock to define the root element", (Object)ex.getMessage());
    }

    @Test
    public void testUnablancedBlock() {
        Exception ex = null;
        try {
            PlanBuilder.create().startBlock(PlanBuilderTest.artefact("Root")).build();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertEquals((Object)"Unbalanced block CustomArtefact [Root]", (Object)ex.getMessage());
    }

    @Test
    public void testEmptyStack() {
        Exception ex = null;
        try {
            PlanBuilder.create().endBlock().build();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((Object)ex);
        Assert.assertEquals((Object)"Empty stack. Please first call startBlock before calling endBlock", (Object)ex.getMessage());
    }

    @Test
    public void test() {
        Plan plan = PlanBuilder.create().startBlock(PlanBuilderTest.artefact("Root")).endBlock().build();
        Assert.assertEquals((long)1L, (long)plan.getArtefacts().size());
        Assert.assertEquals((Object)"Root", (Object)((AbstractArtefact)plan.getArtefacts().iterator().next()).getDescription());
    }

    public static AbstractArtefact artefact(String description) {
        CustomArtefact a = new CustomArtefact();
        a.setDescription(description);
        return a;
    }

    public static class CustomHandler
    extends ArtefactHandler<CustomArtefact, ReportNode> {
        protected void createReportSkeleton_(ReportNode parentNode, CustomArtefact testArtefact) {
        }

        protected void execute_(ReportNode node, CustomArtefact testArtefact) throws Exception {
            if (testArtefact.getChildrenIDs() != null) {
                testArtefact.getChildrenIDs().forEach(childId -> ArtefactHandler.delegateExecute((ExecutionContext)this.context, (AbstractArtefact)((AbstractArtefact)this.context.getArtefactAccessor().get(childId)), (ReportNode)node));
            }
            node.setStatus(ReportNodeStatus.PASSED);
        }

        public ReportNode createReportNode_(ReportNode parentNode, CustomArtefact testArtefact) {
            return new ReportNode();
        }
    }

    @Artefact(name="Custom", handler=CustomHandler.class)
    public static class CustomArtefact
    extends AbstractArtefact {
        public String toString() {
            return "CustomArtefact [" + this.getDescription() + "]";
        }
    }
}

