/*
 * Decompiled with CFR 0.152.
 */
package step.client.planrunners;

import ch.exense.commons.io.Poller;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import step.client.AbstractRemoteClient;
import step.client.accessors.RemotePlanAccessorImpl;
import step.client.credentials.ControllerCredentials;
import step.client.reports.RemoteReportTreeAccessor;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.reports.ReportTreeAccessor;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.plans.Plan;
import step.core.plans.PlanAccessor;
import step.core.plans.runner.PlanRunner;
import step.core.plans.runner.PlanRunnerResult;
import step.core.repositories.RepositoryObjectReference;

public class RemotePlanRunner
extends AbstractRemoteClient
implements PlanRunner {
    private PlanAccessor planAccessor;

    public RemotePlanRunner() {
        this.planAccessor = new RemotePlanAccessorImpl();
    }

    public RemotePlanRunner(ControllerCredentials credentials) {
        super(credentials);
        this.planAccessor = new RemotePlanAccessorImpl(credentials);
    }

    public PlanRunnerResult run(Plan plan) {
        return this.run(plan, new HashMap<String, String>());
    }

    public PlanRunnerResult run(Plan plan, Map<String, String> executionParameters) {
        this.planAccessor.save((AbstractIdentifiableObject)plan);
        String planId = plan.getId().toString();
        String name = (String)plan.getAttributes().get("name");
        return this.runPlanById(executionParameters, planId, name);
    }

    public PlanRunnerResult runPlanById(Map<String, String> executionParameters, String planId, String name) {
        ExecutionParameters params = new ExecutionParameters();
        HashMap<String, String> repositoryParameters = new HashMap<String, String>();
        repositoryParameters.put("planid", planId);
        params.setRepositoryObject(new RepositoryObjectReference("local", repositoryParameters));
        params.setMode(ExecutionMode.RUN);
        params.setDescription(name);
        params.setUserID(this.credentials.getUsername());
        params.setCustomParameters(executionParameters);
        params.setIsolatedExecution(Boolean.valueOf(false));
        Invocation.Builder b = this.requestBuilder("/rest/controller/execution");
        Entity entity = Entity.entity((Object)params, (String)"application/json");
        String executionId = this.executeRequest(() -> (String)b.post(entity, String.class));
        RemoteReportTreeAccessor reportTreeAccessor = new RemoteReportTreeAccessor(this.credentials);
        return new RemotePlanRunnerResult(executionId, executionId, reportTreeAccessor);
    }

    public Execution getExecution(String executionID) {
        Invocation.Builder b = this.requestBuilder("/rest/executions/" + executionID);
        return this.executeRequest(() -> (Execution)b.get(Execution.class));
    }

    public Execution waitForExecutionToTerminate(String executionID, long timeout) throws TimeoutException, InterruptedException {
        Poller.waitFor(() -> this.getExecution(executionID).getStatus().equals((Object)ExecutionStatus.ENDED), (long)timeout);
        return this.getExecution(executionID);
    }

    public AbstractArtefact getArtefact(String artefactId) {
        Invocation.Builder b = this.requestBuilder("/rest/controller/artefact/" + artefactId);
        return this.executeRequest(() -> (AbstractArtefact)b.get(AbstractArtefact.class));
    }

    public class RemotePlanRunnerResult
    extends PlanRunnerResult {
        public RemotePlanRunnerResult(String executionId, String rootReportNodeId, ReportTreeAccessor reportTreeAccessor) {
            super(executionId, rootReportNodeId, reportTreeAccessor);
        }

        public PlanRunnerResult waitForExecutionToTerminate(long timeout) throws TimeoutException, InterruptedException {
            RemotePlanRunner.this.waitForExecutionToTerminate(this.executionId, timeout);
            return this;
        }
    }
}

