/*
 * Decompiled with CFR 0.152.
 */
package step.client.functions;

import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.functions.Function;
import step.functions.manager.FunctionManager;
import step.functions.type.FunctionTypeException;

public class RemoteFunctionManagerImpl
extends AbstractRemoteClient
implements FunctionManager {
    public RemoteFunctionManagerImpl(ControllerCredentials credentials) {
        super(credentials);
    }

    public RemoteFunctionManagerImpl() {
    }

    public Function getFunctionByAttributes(Map<String, String> attributes) {
        Invocation.Builder b = this.requestBuilder("/rest/functions/search");
        Entity entity = Entity.entity(attributes, (String)"application/json");
        return (Function)b.post(entity, Function.class);
    }

    public Function getFunctionById(String id) {
        Invocation.Builder b = this.requestBuilder("/rest/functions/" + id);
        return this.executeRequest(() -> (Function)b.get(Function.class));
    }

    public Function saveFunction(Function function) {
        Invocation.Builder b = this.requestBuilder("/rest/functions");
        Entity entity = Entity.entity((Object)function, (String)"application/json");
        return this.executeRequest(() -> (Function)b.post(entity, Function.class));
    }

    public void deleteFunction(String functionId) {
        Invocation.Builder b = this.requestBuilder("/rest/functions/" + functionId);
        this.executeRequest(() -> b.delete());
    }

    public Function copyFunction(String functionId) throws FunctionTypeException {
        throw new RuntimeException("Not implemented");
    }

    public Function newFunction(String functionType) {
        throw new RuntimeException("Not implemented");
    }
}

