/*
 * Decompiled with CFR 0.152.
 */
package step.client.eventbroker;

import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.plugins.events.Event;
import step.plugins.events.EventBrokerClient;

public class RemoteEventBrokerClient
extends AbstractRemoteClient
implements EventBrokerClient {
    public static String servicePath = "/rest/eventbroker";
    private GenericType<Map<String, Set<Event>>> mapStringSetEvent = new GenericType<Map<String, Set<Event>>>(){};
    private GenericType<Set<Event>> setEvent = new GenericType<Set<Event>>(){};
    private GenericType<Map<String, Event>> mapStringEvent = new GenericType<Map<String, Event>>(){};

    public RemoteEventBrokerClient(ControllerCredentials credentials) {
        super(credentials);
    }

    public RemoteEventBrokerClient() {
    }

    @Deprecated
    public String getEventBrokerStatus() {
        return this.getEventBrokerGroupMap().toString();
    }

    public Map<String, Event> getEventBrokerIdMap() {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/asIdMap").get(this.mapStringEvent));
    }

    public Map<String, Event> getEventBrokerIdMap(int skip, int limit) {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/asIdMap/skip/" + skip + "/limit/" + limit).get(this.mapStringEvent));
    }

    public Map<String, Set<Event>> getEventBrokerGroupMap() {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/asGroupMap").get(this.mapStringSetEvent));
    }

    public Map<String, Set<Event>> getEventBrokerGroupMap(int skip, int limit) {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/asGroupMap/skip/" + skip + "/limit/" + limit).get(this.mapStringSetEvent));
    }

    public Event putEvent(Event event) {
        Entity entity = Entity.entity((Object)event, (String)"application/json");
        event.setSubmitionTimestamp(System.currentTimeMillis());
        return this.executeRequest(() -> (Event)this.requestBuilder(servicePath + "/event").post(entity, Event.class));
    }

    public Event peekEvent(String id) {
        Event event = this.executeRequest(() -> (Event)this.requestBuilder(servicePath + "/event/" + id).get(Event.class));
        if (event != null) {
            event.setReceptionTimestamp(System.currentTimeMillis());
        }
        return event;
    }

    public Event peekEventByGroupAndName(String group, String name) throws Exception {
        RemoteEventBrokerClient.failOnEmptyString("group", group);
        Event event = this.executeRequest(() -> (Event)this.requestBuilder(servicePath + "/event/group/" + group + "/name/" + name).get(Event.class));
        if (event != null) {
            event.setReceptionTimestamp(System.currentTimeMillis());
        }
        return event;
    }

    public Event consumeEvent(String id) {
        Event event = this.executeRequest(() -> (Event)this.requestBuilder(servicePath + "/event/" + id).delete(Event.class));
        if (event != null) {
            event.setReceptionTimestamp(System.currentTimeMillis());
        }
        return event;
    }

    public Event consumeEventByGroupAndName(String group, String name) throws Exception {
        RemoteEventBrokerClient.failOnEmptyString("group", group);
        Event event = this.executeRequest(() -> (Event)this.requestBuilder(servicePath + "/event/group/" + group + "/name/" + name).delete(Event.class));
        if (event != null) {
            event.setReceptionTimestamp(System.currentTimeMillis());
        }
        return event;
    }

    public Map<String, Boolean> clear() {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events").delete(Map.class));
    }

    public Map<String, Boolean> clearGroup(String group) {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/group/" + group).delete(Map.class));
    }

    public Map<String, Object> getGlobalStats() {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/monitoring/global").get(Map.class));
    }

    public Map<String, Object> getGroupStats(String group) {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/monitoring/group/" + group).get(Map.class));
    }

    public Map<String, Object> clearStats() {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/monitoring/clear").get(Map.class));
    }

    public Set<Event> getGroupSkipLimit(String group, int skip, int limit) throws Exception {
        RemoteEventBrokerClient.failOnEmptyString("group", group);
        return this.executeRequest(() -> (Set)this.requestBuilder(servicePath + "/events/group/" + group + "/skip/" + skip + "/limit/" + limit).get(Set.class));
    }

    public Set<Event> getFullGroup(String group) {
        return this.executeRequest(() -> (Set)this.requestBuilder(servicePath + "/events/group/" + group).get(this.setEvent));
    }

    public Set<String> getDistinctGroupNames() {
        return this.executeRequest(() -> (Set)this.requestBuilder(servicePath + "/events/groups").get(Set.class));
    }

    public int getGroupSize(String group) {
        return this.executeRequest(() -> (Integer)this.requestBuilder(servicePath + "/events/group/" + group + "/size").get(Integer.class));
    }

    public Map<String, Object> setCircuitBreakerThreshold(long circuitBreakerThreshold) {
        return this.executeRequest(() -> (Map)this.requestBuilder(servicePath + "/events/config/circuitBreakerThreshold/" + circuitBreakerThreshold).get(Map.class));
    }

    private static void failOnEmptyString(String stringName, String value) throws Exception {
        if (value != null && value.isEmpty()) {
            throw new Exception("Empty string not accepted for parameter \"" + stringName + "\". Either choose a different method or use the wildcard character \"*\".");
        }
    }
}

