/*
 * Decompiled with CFR 0.152.
 */
package step.client.accessors;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.GenericType;
import org.bson.types.ObjectId;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.commons.iterators.SkipLimitIterator;
import step.commons.iterators.SkipLimitProvider;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.CRUDAccessor;

public class AbstractRemoteCRUDAccessorImpl<T extends AbstractIdentifiableObject>
extends AbstractRemoteClient
implements CRUDAccessor<T> {
    private final String path;
    private final Class<T> entityClass;
    protected ParameterizedType parameterizedGenericType = new ParameterizedType(){

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{AbstractRemoteCRUDAccessorImpl.this.entityClass};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return List.class;
        }
    };
    protected GenericType<List<T>> genericEntity = new GenericType<List<T>>(this.parameterizedGenericType){};

    public AbstractRemoteCRUDAccessorImpl(String path, Class<T> entityClass) {
        this.path = path;
        this.entityClass = entityClass;
    }

    public AbstractRemoteCRUDAccessorImpl(ControllerCredentials credentials, String path, Class<T> entityClass) {
        super(credentials);
        this.path = path;
        this.entityClass = entityClass;
    }

    public T get(ObjectId id) {
        Invocation.Builder b = this.requestBuilder(this.path + id.toString());
        return (T)this.executeRequest(() -> (AbstractIdentifiableObject)b.get(this.entityClass));
    }

    public T get(String id) {
        return this.get(new ObjectId(id));
    }

    public T findByAttributes(Map<String, String> attributes) {
        Invocation.Builder b = this.requestBuilder(this.path + "search");
        Entity entity = Entity.entity(attributes, (String)"application/json");
        return (T)this.executeRequest(() -> (AbstractIdentifiableObject)b.post(entity, this.entityClass));
    }

    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        Invocation.Builder b = this.requestBuilder(this.path + "find");
        Entity entity = Entity.entity(attributes, (String)"application/json");
        return this.executeRequest(() -> (List)b.post(entity, this.genericEntity)).spliterator();
    }

    public Iterator<T> getAll() {
        SkipLimitIterator skipLimitIterator = new SkipLimitIterator(new SkipLimitProvider<T>(){

            public List<T> getBatch(int skip, int limit) {
                return AbstractRemoteCRUDAccessorImpl.this.getRange(skip, limit);
            }
        });
        return skipLimitIterator;
    }

    public List<T> getRange(int skip, int limit) {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.put("skip", Integer.toString(skip));
        queryParams.put("limit", Integer.toString(limit));
        GenericType genericEntity = new GenericType<List<T>>(this.parameterizedGenericType){};
        Invocation.Builder b = this.requestBuilder(this.path, queryParams);
        return this.executeRequest(() -> AbstractRemoteCRUDAccessorImpl.lambda$getRange$3(b, (GenericType)genericEntity));
    }

    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        throw this.notImplemented();
    }

    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        throw this.notImplemented();
    }

    public void remove(ObjectId id) {
        Invocation.Builder b = this.requestBuilder(this.path + id);
        this.executeRequest(() -> (AbstractIdentifiableObject)b.delete(this.entityClass));
    }

    public T save(T e) {
        Invocation.Builder b = this.requestBuilder(this.path);
        Entity entity = Entity.entity(e, (String)"application/json");
        return (T)this.executeRequest(() -> (AbstractIdentifiableObject)b.post(entity, this.entityClass));
    }

    public void save(Collection<? extends T> entities) {
        entities.forEach(e -> this.save(e));
    }

    private static /* synthetic */ List lambda$getRange$3(Invocation.Builder b, GenericType genericEntity) {
        return (List)b.get(genericEntity);
    }
}

