/*
 * Decompiled with CFR 0.152.
 */
package step.core.deployment;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr353.JSR353Module;
import java.io.IOException;
import javax.ws.rs.ext.ContextResolver;
import org.bson.types.ObjectId;

public class JacksonMapperProvider
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper mapper = JacksonMapperProvider.createMapper();
    private static Class<ObjectId> _id = ObjectId.class;

    public ObjectMapper getContext(Class<?> type) {
        return this.mapper;
    }

    public static ObjectMapper createMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JSR353Module());
        mapper.registerModule((Module)new JsonOrgModule());
        mapper.registerModule((Module)new SimpleModule("jersey", new Version(1, 0, 0, null, null, null)).addSerializer(_id, JacksonMapperProvider._idSerializer()).addDeserializer(_id, JacksonMapperProvider._idDeserializer()));
        return mapper;
    }

    private static JsonDeserializer<ObjectId> _idDeserializer() {
        return new JsonDeserializer<ObjectId>(){

            public ObjectId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                return new ObjectId((String)jp.readValueAs(String.class));
            }
        };
    }

    private static JsonSerializer<Object> _idSerializer() {
        return new JsonSerializer<Object>(){

            public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException, JsonProcessingException {
                jsonGenerator.writeString(obj == null ? null : obj.toString());
            }
        };
    }
}

