/*
 * Decompiled with CFR 0.152.
 */
package step.client.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.grid.io.Attachment;
import step.grid.io.AttachmentHelper;
import step.resources.Resource;
import step.resources.ResourceManager;
import step.resources.ResourceRevision;
import step.resources.ResourceRevisionContainer;
import step.resources.ResourceRevisionContent;
import step.resources.ResourceRevisionContentImpl;
import step.resources.ResourceRevisionFileHandle;
import step.resources.ResourceUploadResponse;
import step.resources.SimilarResourceExistingException;

public class RemoteResourceManager
extends AbstractRemoteClient
implements ResourceManager {
    public RemoteResourceManager() {
    }

    public RemoteResourceManager(ControllerCredentials credentials) {
        super(credentials);
    }

    public ResourceUploadResponse upload(File file) {
        FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
        return this.upload((FormDataBodyPart)fileDataBodyPart);
    }

    public ResourceUploadResponse upload(String filename, InputStream stream) {
        StreamDataBodyPart bodyPart = new StreamDataBodyPart("file", stream, filename);
        return this.upload((FormDataBodyPart)bodyPart);
    }

    protected ResourceUploadResponse upload(FormDataBodyPart bodyPart) {
        return this.upload(bodyPart, "stagingContextFiles", true);
    }

    protected ResourceUploadResponse upload(FormDataBodyPart bodyPart, String type, boolean checkForDuplicates) {
        MultiPart multiPart = new MultiPart();
        multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
        multiPart.bodyPart((BodyPart)bodyPart);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", type);
        params.put("duplicateCheck", Boolean.toString(checkForDuplicates));
        Invocation.Builder b = this.requestBuilder("/rest/resources/content", params);
        return this.executeRequest(() -> (ResourceUploadResponse)b.post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()), ResourceUploadResponse.class));
    }

    public Attachment download(String resourceId) {
        Invocation.Builder b = this.requestBuilder("/rest/resources/" + resourceId + "/content");
        return this.executeRequest(() -> AttachmentHelper.generateAttachmentFromByteArray((byte[])((byte[])b.get(byte[].class)), (String)"unnamed"));
    }

    public Resource createResource(String resourceType, InputStream resourceStream, String resourceFileName, boolean checkForDuplicates, Map<String, String> sessionQueryFragments) throws IOException, SimilarResourceExistingException {
        StreamDataBodyPart bodyPart = new StreamDataBodyPart("file", resourceStream, resourceFileName);
        ResourceUploadResponse upload = this.upload((FormDataBodyPart)bodyPart, resourceType, checkForDuplicates);
        return upload.getResource();
    }

    public Resource saveResourceContent(String resourceId, InputStream resourceStream, String resourceFileName) throws IOException {
        return null;
    }

    public void deleteResource(String resourceId) {
        Invocation.Builder b = this.requestBuilder("/rest/resources/" + resourceId);
        this.executeRequest(() -> b.delete());
    }

    public ResourceRevisionContent getResourceContent(String resourceId) throws IOException {
        final Resource resource = this.getResource(resourceId);
        final Invocation.Builder b = this.requestBuilder("/rest/resources/" + resourceId + "/content");
        return new ResourceRevisionContent(){

            public InputStream getResourceStream() {
                InputStream in = (InputStream)b.get().getEntity();
                return in;
            }

            public String getResourceName() {
                return resource.getResourceName();
            }

            public void close() throws IOException {
            }
        };
    }

    public Resource getResource(String resourceId) {
        Invocation.Builder b = this.requestBuilder("/rest/resources/" + resourceId);
        Resource resource = this.executeRequest(() -> (Resource)b.get(Resource.class));
        return resource;
    }

    public ResourceRevisionFileHandle getResourceFile(String resourceId) {
        Resource resource = this.getResource(resourceId);
        Invocation.Builder b = this.requestBuilder("/rest/resources/" + resourceId + "/content");
        byte[] content = this.executeRequest(() -> (byte[])b.get(byte[].class));
        File container = new File("resources/" + resourceId);
        container.mkdirs();
        final File file = new File(container.getAbsolutePath() + "/" + resource.getResourceName());
        try {
            Files.copy(new ByteArrayInputStream(content), file.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new ResourceRevisionFileHandle(){

            public File getResourceFile() {
                return file;
            }

            public void close() throws IOException {
            }
        };
    }

    public ResourceRevision getResourceRevisionByResourceId(String resourceId) {
        throw new RuntimeException("Not implemented");
    }

    public ResourceRevisionContentImpl getResourceRevisionContent(String resourceRevisionId) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public ResourceRevisionContainer createResourceContainer(String resourceType, String resourceFileName) throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public Resource lookupResourceByName(String resourcename) {
        throw new RuntimeException("Not implemented");
    }

    public boolean resourceExists(String resourceId) {
        throw new RuntimeException("Not implemented");
    }

    public Resource saveResource(Resource resource) throws IOException {
        throw new RuntimeException("Not implemented");
    }
}

