/*
 * Decompiled with CFR 0.152.
 */
package step.client.repository;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.MultiPart;
import org.glassfish.jersey.media.multipart.file.FileDataBodyPart;
import org.glassfish.jersey.media.multipart.file.StreamDataBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.client.planrunners.RemotePlanRunner;
import step.client.reports.RemoteReportTreeAccessor;
import step.core.plans.Plan;
import step.core.plans.runner.PlanRunnerResult;

public class StagingRepositoryClient
extends AbstractRemoteClient {
    private static final Logger logger = LoggerFactory.getLogger(StagingRepositoryClient.class);

    public StagingRepositoryClient() {
    }

    public StagingRepositoryClient(ControllerCredentials credentials) {
        super(credentials);
    }

    public StagingContext createContext() {
        Invocation.Builder b = this.requestBuilder("/rest/staging/context");
        String contextId = this.executeRequest(() -> (String)b.get(String.class));
        StagingContext context = new StagingContext(this.credentials, contextId);
        return context;
    }

    public static class StagingContext
    extends AbstractRemoteClient {
        protected String contextId;
        List<Closeable> closables = new ArrayList<Closeable>();

        public StagingContext(ControllerCredentials credentials, String contextId) {
            super(credentials);
            this.contextId = contextId;
        }

        public String uploadFile(File file) {
            FileDataBodyPart fileDataBodyPart = new FileDataBodyPart("file", file, MediaType.APPLICATION_OCTET_STREAM_TYPE);
            MultiPart multiPart = new MultiPart();
            multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
            multiPart.bodyPart((BodyPart)fileDataBodyPart);
            Invocation.Builder b = this.requestBuilder("/rest/staging/context/" + this.contextId + "/file");
            return this.executeRequest(() -> (String)b.post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()), String.class));
        }

        public String upload(InputStream stream, String resourceName) {
            StreamDataBodyPart streamDataBodyPart = new StreamDataBodyPart("file", stream, resourceName);
            MultiPart multiPart = new MultiPart();
            multiPart.setMediaType(MediaType.MULTIPART_FORM_DATA_TYPE);
            multiPart.bodyPart((BodyPart)streamDataBodyPart);
            Invocation.Builder b = this.requestBuilder("/rest/staging/context/" + this.contextId + "/file");
            return this.executeRequest(() -> (String)b.post(Entity.entity((Object)multiPart, (MediaType)multiPart.getMediaType()), String.class));
        }

        public void uploadPlan(Plan plan) {
            Invocation.Builder b = this.requestBuilder("/rest/staging/context/" + this.contextId + "/plan");
            Entity entity = Entity.entity((Object)plan, (String)"application/json");
            this.executeRequest(() -> b.post(entity));
        }

        public PlanRunnerResult run() {
            return this.run(new HashMap<String, String>());
        }

        public PlanRunnerResult run(Map<String, String> executionParameters) {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("isolate", "true");
            Invocation.Builder b = this.requestBuilder("/rest/staging/context/" + this.contextId + "/execute", queryParams);
            Entity entity = Entity.entity(executionParameters, (String)"application/json");
            String executionId = this.executeRequest(() -> (String)b.post(entity, String.class));
            RemotePlanRunner remotePlanRunner = new RemotePlanRunner(this.credentials);
            this.closables.add(remotePlanRunner);
            RemotePlanRunner remotePlanRunner2 = remotePlanRunner;
            remotePlanRunner2.getClass();
            return remotePlanRunner2.new RemotePlanRunner.RemotePlanRunnerResult(executionId, executionId, new RemoteReportTreeAccessor(this.credentials));
        }

        @Override
        public void close() {
            Invocation.Builder b = this.requestBuilder("/rest/staging/context/" + this.contextId + "/destroy");
            this.executeRequest(() -> b.post(Entity.json((Object)"{}")));
            this.closables.forEach(c -> {
                try {
                    c.close();
                }
                catch (IOException e) {
                    logger.error("Error while closing client " + c.toString(), c);
                }
            });
        }
    }
}

