/*
 * Decompiled with CFR 0.152.
 */
package step.client.planrepository;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.types.ObjectId;
import step.client.accessors.RemoteArtefactAccessor;
import step.client.credentials.ControllerCredentials;
import step.core.artefacts.AbstractArtefact;
import step.core.plans.Plan;
import step.core.plans.PlanRepository;

public class RemotePlanRepository
implements PlanRepository {
    RemoteArtefactAccessor repositoryClient;

    public RemotePlanRepository(ControllerCredentials credentials) {
        this.repositoryClient = new RemoteArtefactAccessor(credentials);
    }

    public RemotePlanRepository() {
        this.repositoryClient = new RemoteArtefactAccessor();
    }

    public Plan load(Map<String, String> attributes) {
        AbstractArtefact root = this.repositoryClient.findByAttributes(attributes);
        ArrayList<AbstractArtefact> artefacts = new ArrayList<AbstractArtefact>();
        this.loadChildren(artefacts, root);
        Plan plan = new Plan(root, artefacts);
        return plan;
    }

    public void save(Plan plan) {
        plan.getArtefacts().forEach(a -> this.repositoryClient.save((AbstractArtefact)a));
    }

    private void loadChildren(List<AbstractArtefact> artefacts, AbstractArtefact artefact) {
        artefacts.add(artefact);
        if (artefact.getChildrenIDs() != null) {
            for (ObjectId childId : artefact.getChildrenIDs()) {
                AbstractArtefact child = this.repositoryClient.get(childId.toString());
                if (child != null) {
                    this.loadChildren(artefacts, child);
                    continue;
                }
                throw new RuntimeException("Unable to find artefact with id: " + childId.toString());
            }
        }
    }
}

