/*
 * Decompiled with CFR 0.152.
 */
package step.client.executions;

import ch.exense.commons.io.Poller;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import step.client.AbstractRemoteClient;
import step.client.credentials.ControllerCredentials;
import step.client.executions.RemoteExecutionFuture;
import step.core.artefacts.reports.ReportNodeStatus;
import step.core.execution.model.Execution;
import step.core.execution.model.ExecutionMode;
import step.core.execution.model.ExecutionParameters;
import step.core.execution.model.ExecutionStatus;
import step.core.repositories.RepositoryObjectReference;

public class RemoteExecutionManager
extends AbstractRemoteClient {
    public RemoteExecutionManager() {
    }

    public RemoteExecutionManager(ControllerCredentials credentials) {
        super(credentials);
    }

    public String execute(String planId) {
        return this.execute(planId, new HashMap<String, String>());
    }

    public String execute(String planId, Map<String, String> parameters) {
        HashMap<String, String> repositoryParameters = new HashMap<String, String>();
        repositoryParameters.put("artefactid", planId);
        RepositoryObjectReference repositoryObjectReference = new RepositoryObjectReference("local", repositoryParameters);
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.setArtefact(repositoryObjectReference);
        executionParameters.setUserID(this.credentials.getUsername());
        executionParameters.setMode(ExecutionMode.RUN);
        executionParameters.setIsolatedExecution(Boolean.valueOf(false));
        executionParameters.setCustomParameters(parameters);
        return this.execute(executionParameters);
    }

    public String executeFromExternalRepository(String repositoryId, Map<String, String> repositoryParameters) {
        RepositoryObjectReference repositoryObjectReference = new RepositoryObjectReference(repositoryId, repositoryParameters);
        ExecutionParameters executionParameters = new ExecutionParameters();
        executionParameters.setArtefact(repositoryObjectReference);
        executionParameters.setUserID(this.credentials.getUsername());
        executionParameters.setMode(ExecutionMode.RUN);
        executionParameters.setIsolatedExecution(Boolean.valueOf(false));
        return this.execute(executionParameters);
    }

    public String execute(ExecutionParameters executionParams) {
        Invocation.Builder b = this.requestBuilder("/rest/controller/execution/");
        Entity entity = Entity.entity((Object)executionParams, (String)"application/json");
        return this.executeRequest(() -> (String)b.post(entity, String.class));
    }

    public void stop(String executionId) {
        Invocation.Builder b = this.requestBuilder("/rest/controller/execution/" + executionId + "/stop");
        this.executeRequest(() -> b.get());
    }

    public Execution get(String executionId) {
        Invocation.Builder b = this.requestBuilder("/rest/controller/execution/" + executionId);
        return this.executeRequest(() -> (Execution)b.get(Execution.class));
    }

    public Map<ReportNodeStatus, Integer> getStatusReport(String executionId, String reportNodeClass) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (reportNodeClass != null) {
            params.put("class", reportNodeClass);
        }
        Invocation.Builder b = this.requestBuilder("/rest/controller/execution/" + executionId + "/statusdistribution", params);
        return this.executeRequest(() -> (Map)b.get(Map.class));
    }

    public Execution waitForTermination(String executionID, long timeout) throws TimeoutException, InterruptedException {
        Poller.waitFor(() -> this.get(executionID).getStatus().equals((Object)ExecutionStatus.ENDED), (long)timeout);
        return this.get(executionID);
    }

    public RemoteExecutionFuture getFuture(String executionId) {
        return new RemoteExecutionFuture(this, executionId);
    }

    protected ControllerCredentials getControllerCredentials() {
        return this.credentials;
    }
}

