/*
 * Decompiled with CFR 0.152.
 */
package step.client.credentials;

public class ControllerCredentials {
    private final String serverUrl;
    private final String username;
    private final String password;

    public ControllerCredentials(String hostname, int port, String username, String password) {
        this.serverUrl = "http://" + hostname + ":" + port;
        this.username = username;
        this.password = password;
    }

    public ControllerCredentials(String serverUrl, String username, String password) {
        if (serverUrl == null || serverUrl.isEmpty()) {
            throw new RuntimeException("Incorrect serverURL: " + serverUrl);
        }
        if (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.serverUrl = serverUrl;
        this.username = username;
        this.password = password;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

