/*
 * Decompiled with CFR 0.152.
 */
package step.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import step.client.ControllerClientException;
import step.client.credentials.ControllerCredentials;
import step.client.credentials.SyspropCredendialsBuilder;
import step.core.access.Credentials;
import step.core.deployment.JacksonMapperProvider;

public class AbstractRemoteClient
implements Closeable {
    protected Client client;
    protected Map<String, NewCookie> cookies;
    protected ControllerCredentials credentials;

    public AbstractRemoteClient(ControllerCredentials credentials) {
        this.credentials = credentials;
        this.createClient();
        if (credentials.getUsername() != null && !credentials.getUsername().trim().isEmpty()) {
            this.login();
        }
    }

    public AbstractRemoteClient() {
        this(SyspropCredendialsBuilder.build());
    }

    private void createClient() {
        this.client = ClientBuilder.newClient();
        this.client.register(JacksonMapperProvider.class);
        this.client.register(MultiPartFeature.class);
        this.client.register(JacksonFeature.class);
    }

    private void login() {
        Credentials c = new Credentials();
        c.setUsername(this.credentials.getUsername());
        c.setPassword(this.credentials.getPassword());
        Entity entity = Entity.entity((Object)c, (String)"application/json");
        System.out.println("Logging into:" + this.credentials.getServerUrl() + " with user " + this.credentials.getUsername());
        this.cookies = this.client.target(this.credentials.getServerUrl() + "/rest/access/login").request().post(entity).getCookies();
    }

    protected Invocation.Builder requestBuilder(String path) {
        return this.requestBuilder(path, null);
    }

    protected Invocation.Builder requestBuilder(String path, Map<String, String> queryParams) {
        WebTarget target = this.client.target(this.credentials.getServerUrl() + path);
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                target = target.queryParam(key, new Object[]{queryParams.get(key)});
            }
        }
        Invocation.Builder b = target.request();
        b.accept(new String[]{"application/json"});
        if (this.cookies != null) {
            for (NewCookie c : this.cookies.values()) {
                b.cookie((Cookie)c);
            }
        }
        return b;
    }

    protected <T> T executeRequest(Supplier<T> provider) throws ControllerClientException {
        try {
            T r = provider.get();
            if (r instanceof Response) {
                Response response = (Response)r;
                if (response.getStatus() != 204 && response.getStatus() != 200) {
                    String error = (String)response.readEntity(String.class);
                    throw new ControllerClientException("Error while calling controller " + this.credentials.getServerUrl() + ". The server returned following error: " + error);
                }
                return r;
            }
            return r;
        }
        catch (WebApplicationException e) {
            String errorMessage = (String)e.getResponse().readEntity(String.class);
            throw new ControllerClientException("Error while calling controller " + this.credentials.getServerUrl() + ". The server returned following error: " + errorMessage, e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected UnsupportedOperationException notImplemented() {
        return new UnsupportedOperationException("This method is currently not implemented");
    }
}

