/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.events;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import step.plugins.events.Event;
import step.plugins.events.EventBroker;
import step.plugins.events.EventBrokerClient;

public class InMemoryEventBrokerClient
implements EventBrokerClient {
    private EventBroker eb;

    public InMemoryEventBrokerClient(EventBroker eb) {
        this.eb = eb;
    }

    @Override
    public Map<String, Event> getEventBrokerIdMap() {
        return this.eb.getIdBasedEventMap();
    }

    @Override
    public Map<String, Event> getEventBrokerIdMap(int skip, int limit) {
        return this.eb.getIdBasedEventMap(skip, limit);
    }

    @Override
    public Map<String, Set<Event>> getEventBrokerGroupMap() {
        return this.eb.getFullGroupBasedEventMap();
    }

    @Override
    public Map<String, Set<Event>> getEventBrokerGroupMap(int skip, int limit) {
        return this.eb.getGroupBasedEventMap(skip, limit);
    }

    @Override
    public Event putEvent(Event event) {
        try {
            return this.eb.put(event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Event peekEvent(String id) {
        return this.eb.peek(id);
    }

    @Override
    public Event peekEventByGroupAndName(String group, String name) {
        return this.eb.peek(group, name);
    }

    @Override
    public Event consumeEvent(String id) {
        return this.eb.get(id);
    }

    @Override
    public Event consumeEventByGroupAndName(String group, String name) {
        return this.eb.get(group, name);
    }

    @Override
    public Map<String, Boolean> clear() {
        this.eb.clear();
        HashMap<String, Boolean> successMap = new HashMap<String, Boolean>();
        successMap.put("success", Boolean.TRUE);
        return successMap;
    }

    @Override
    public Map<String, Boolean> clearGroup(String group) {
        this.eb.clearStats();
        HashMap<String, Boolean> successMap = new HashMap<String, Boolean>();
        successMap.put("success", Boolean.TRUE);
        return successMap;
    }

    @Override
    public Map<String, Object> getGlobalStats() {
        return this.eb.getStats();
    }

    @Override
    public Map<String, Object> getGroupStats(String group) {
        return this.eb.getGroupStats(group);
    }

    @Override
    public Map<String, Object> clearStats() {
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        successMap.put("success", "true");
        return successMap;
    }

    @Override
    public Set<Event> getGroupSkipLimit(String group, int skip, int limit) {
        return this.eb.getGroupEvents(group, skip, limit);
    }

    @Override
    public Set<Event> getFullGroup(String group) {
        return this.eb.getGroupEvents(group);
    }

    @Override
    public Set<String> getDistinctGroupNames() {
        return this.eb.getDistinctGroupNames();
    }

    @Override
    public int getGroupSize(String group) {
        return this.eb.getSizeForGroup(group);
    }

    @Override
    public Map<String, Object> setCircuitBreakerThreshold(long circuitBreakerThreshold) {
        this.eb.setCircuitBreakerThreshold(circuitBreakerThreshold);
        HashMap<String, Object> successMap = new HashMap<String, Object>();
        successMap.put("success", "true");
        return successMap;
    }

    @Override
    public void close() throws IOException {
    }
}

