/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.interactive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.artefacts.CallFunction;
import step.artefacts.FunctionGroup;
import step.artefacts.handlers.FunctionGroupHandler;
import step.core.AbstractContext;
import step.core.GlobalContext;
import step.core.artefacts.AbstractArtefact;
import step.core.artefacts.ArtefactAccessor;
import step.core.artefacts.handlers.ArtefactHandler;
import step.core.artefacts.reports.ReportNode;
import step.core.deployment.AbstractServices;
import step.core.deployment.Secured;
import step.core.execution.ControllerSideExecutionContextBuilder;
import step.core.execution.ExecutionContext;
import step.core.objectenricher.ObjectHookRegistry;
import step.core.plans.LocalPlanRepository;
import step.core.plans.Plan;
import step.core.plans.builder.PlanBuilder;
import step.core.variables.VariableType;
import step.functions.Function;
import step.functions.execution.FunctionExecutionService;
import step.functions.execution.FunctionExecutionServiceException;
import step.functions.manager.FunctionManager;
import step.grid.client.AbstractGridClientImpl;
import step.planbuilder.FunctionArtefacts;
import step.plugins.parametermanager.ParameterManagerPlugin;

@Singleton
@Path(value="interactive")
public class InteractiveServices
extends AbstractServices {
    private static final Logger logger = LoggerFactory.getLogger(InteractiveServices.class);
    private Map<String, InteractiveSession> sessions = new ConcurrentHashMap<String, InteractiveSession>();
    private Timer sessionExpirationTimer = new Timer("Session expiration timer");
    private ObjectHookRegistry objectHookRegistry;

    public InteractiveServices() {
        this.sessionExpirationTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                int sessionTimeout = InteractiveServices.this.configuration.getPropertyAsInteger("ui.artefacteditor.interactive.sessiontimeout.minutes", Integer.valueOf(10)) * 60000;
                long time = System.currentTimeMillis();
                InteractiveServices.this.sessions.forEach((sessionId, session) -> {
                    if (session.lasttouch + (long)sessionTimeout < time) {
                        try {
                            InteractiveServices.this.closeSession(session);
                        }
                        catch (FunctionExecutionServiceException functionExecutionServiceException) {
                            // empty catch block
                        }
                        InteractiveServices.this.sessions.remove(sessionId);
                    }
                });
            }
        }, 60000L, 60000L);
    }

    @PostConstruct
    public void init() throws Exception {
        super.init();
        this.objectHookRegistry = (ObjectHookRegistry)this.getContext().get(ObjectHookRegistry.class);
    }

    @PreDestroy
    private void close() {
        if (this.sessionExpirationTimer != null) {
            this.sessionExpirationTimer.cancel();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/start")
    @Secured(right="interactive")
    public String start(@Context ContainerRequestContext crc) throws AbstractGridClientImpl.AgentCommunicationException {
        InteractiveSession session = new InteractiveSession();
        ExecutionContext executionContext = ControllerSideExecutionContextBuilder.createExecutionContext((GlobalContext)this.getContext());
        this.objectHookRegistry.getObjectEnricher((AbstractContext)this.getSession(crc)).accept((Object)executionContext.getExecutionParameters());
        session.c = executionContext;
        session.lasttouch = System.currentTimeMillis();
        session.root = new ReportNode();
        session.functionGroupContext = new FunctionGroupHandler.FunctionGroupContext(null);
        String id = executionContext.getExecutionId();
        executionContext.getReportNodeCache().put(session.root);
        executionContext.setReport(session.root);
        executionContext.setCurrentReportNode(session.root);
        session.c.getVariablesManager().putVariable(session.root, "##functionGroupContext##", (Object)session.functionGroupContext);
        executionContext.getExecutionCallbacks().executionStart(executionContext);
        this.sessions.put(id, session);
        return id;
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/stop")
    @Secured(right="interactive")
    public void stop(@PathParam(value="id") String sessionId) throws FunctionExecutionServiceException {
        InteractiveSession session = this.getAndTouchSession(sessionId);
        if (session != null) {
            this.closeSession(session);
        }
    }

    private void closeSession(InteractiveSession session) throws FunctionExecutionServiceException {
        List tokens = session.functionGroupContext.getTokens();
        if (tokens != null) {
            FunctionExecutionService functionExecutionService = (FunctionExecutionService)this.getContext().get(FunctionExecutionService.class);
            tokens.forEach(t -> {
                try {
                    functionExecutionService.returnTokenHandle(t.getID());
                }
                catch (FunctionExecutionServiceException e) {
                    logger.warn("Error while closing interactive session", (Throwable)e);
                }
            });
        }
        session.c.getExecutionCallbacks().afterExecutionEnd(session.c);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/execute/{artefactid}")
    @Secured(right="interactive")
    public ReportNode executeArtefact(@PathParam(value="id") String sessionId, @PathParam(value="artefactid") String artefactId, ExecutionParameters executionParameters, @Context ContainerRequestContext crc) {
        InteractiveSession session = this.getAndTouchSession(sessionId);
        if (session != null) {
            ArtefactAccessor a = this.getContext().getArtefactAccessor();
            AbstractArtefact artefact = a.get(artefactId);
            session.c.getArtefactCache().clear();
            session.c.setCurrentReportNode(session.root);
            ParameterManagerPlugin.putVariables(session.c, session.root, executionParameters.getExecutionParameters(), VariableType.IMMUTABLE);
            ArtefactHandler.delegateCreateReportSkeleton((ExecutionContext)session.c, (AbstractArtefact)artefact, (ReportNode)session.root);
            ArtefactHandler.delegateExecute((ExecutionContext)session.c, (AbstractArtefact)artefact, (ReportNode)session.root);
            return null;
        }
        throw new RuntimeException("Session doesn't exist or expired.");
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/functiontest/{keywordid}/start")
    @Secured(right="interactive")
    public FunctionTestingSession startFunctionTestingSession(@PathParam(value="keywordid") String keywordid) throws AbstractGridClientImpl.AgentCommunicationException {
        CallFunction callFunction = FunctionArtefacts.keywordById((String)keywordid, (String)"{}");
        FunctionManager functionManager = (FunctionManager)this.getContext().get(FunctionManager.class);
        Function function = functionManager.getFunctionById(keywordid);
        HashMap attributes = new HashMap();
        attributes.put("name", function.getAttributes().get("name"));
        callFunction.setAttributes(attributes);
        FunctionGroup functionGroup = new FunctionGroup();
        attributes = new HashMap();
        attributes.put("name", "Session");
        functionGroup.setAttributes(attributes);
        Plan plan = PlanBuilder.create().startBlock((AbstractArtefact)functionGroup).add((AbstractArtefact)callFunction).endBlock().build();
        LocalPlanRepository repo = new LocalPlanRepository(this.getContext().getArtefactAccessor());
        repo.save(plan);
        FunctionTestingSession result = new FunctionTestingSession();
        result.setRootArtefactId(plan.getRoot().getId().toString());
        result.setCallFunctionId(callFunction.getId().toString());
        return result;
    }

    private InteractiveSession getAndTouchSession(String sessionId) {
        InteractiveSession session = this.sessions.get(sessionId);
        if (session != null) {
            session.lasttouch = System.currentTimeMillis();
        }
        return session;
    }

    public static class FunctionTestingSession {
        private String rootArtefactId;
        private String callFunctionId;

        public String getRootArtefactId() {
            return this.rootArtefactId;
        }

        public void setRootArtefactId(String rootArtefactId) {
            this.rootArtefactId = rootArtefactId;
        }

        public String getCallFunctionId() {
            return this.callFunctionId;
        }

        public void setCallFunctionId(String callFunctionId) {
            this.callFunctionId = callFunctionId;
        }
    }

    public static class ExecutionParameters {
        Map<String, String> executionParameters;

        public Map<String, String> getExecutionParameters() {
            return this.executionParameters;
        }

        public void setExecutionParameters(Map<String, String> executionParameters) {
            this.executionParameters = executionParameters;
        }
    }

    private static class InteractiveSession {
        ExecutionContext c;
        ReportNode root;
        FunctionGroupHandler.FunctionGroupContext functionGroupContext;
        long lasttouch;

        private InteractiveSession() {
        }
    }
}

