/*
 * Decompiled with CFR 0.152.
 */
package step.commons.iterators;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import step.commons.iterators.SkipLimitProvider;

public class SkipLimitIterator<T>
implements Iterator<T> {
    private final int batchSize;
    private final SkipLimitProvider<T> provider;
    private Iterator<T> currentBatchIt = null;
    private int currentBatchCount = 0;
    private int currentSkip = 0;
    private T next = null;

    public SkipLimitIterator(SkipLimitProvider<T> provider) {
        this(provider, 1000);
    }

    public SkipLimitIterator(SkipLimitProvider<T> provider, int batchSize) {
        this.provider = provider;
        this.batchSize = batchSize;
        this.getNextBatch();
        this.preloadNextElement();
    }

    protected void preloadNextElement() {
        if (this.currentBatchIt.hasNext()) {
            ++this.currentBatchCount;
            this.next = this.currentBatchIt.next();
        } else if (this.currentBatchCount >= this.batchSize) {
            this.getNextBatch();
            this.preloadNextElement();
        } else {
            this.next = null;
        }
    }

    protected void getNextBatch() {
        List<T> batch = this.provider.getBatch(this.currentSkip, this.batchSize);
        if (batch.size() > this.batchSize) {
            throw new RuntimeException("The size of the batch returned by the SkipLimitProvider is higher than the specified batch size. Expected size was " + this.batchSize + ". Actual batch size was " + batch.size());
        }
        this.currentBatchIt = batch.iterator();
        this.currentBatchCount = 0;
        this.currentSkip += this.batchSize;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        T result = this.next;
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        this.preloadNextElement();
        return result;
    }
}

