/*
 * Decompiled with CFR 0.152.
 */
package step.plugins.selenium;

import java.io.File;
import java.util.Map;
import step.core.dynamicbeans.DynamicValue;
import step.functions.type.SetupFunctionException;
import step.plugins.java.AbstractScriptFunctionType;
import step.plugins.java.GeneralScriptFunction;
import step.plugins.selenium.SeleniumFunction;

public class SeleniumFunctionType
extends AbstractScriptFunctionType<SeleniumFunction> {
    public Map<String, String> getHandlerProperties(SeleniumFunction function) {
        String seleniumVersion = function.getSeleniumVersion();
        String propertyName = "plugins.selenium.libs." + seleniumVersion;
        String seleniumLibPath = this.getContext().getConfiguration().getProperty(propertyName);
        if (seleniumLibPath == null) {
            throw new RuntimeException("Property '" + propertyName + "' in step.properties isn't set. Please set it to path of the installation folder of selenium");
        }
        File seleniumLibFile = new File(seleniumLibPath);
        if (!seleniumLibFile.exists()) {
            throw new RuntimeException("The path to the selenium installation doesn't exist: " + seleniumLibFile.getAbsolutePath());
        }
        function.setLibrariesFile(new DynamicValue((Object)seleniumLibPath));
        return super.getHandlerProperties((GeneralScriptFunction)function);
    }

    public void setupFunction(SeleniumFunction function) throws SetupFunctionException {
        if (((String)function.getScriptLanguage().get()).equals("javascript")) {
            this.setupScriptFile(function, "kw_selenium.js");
        }
    }

    public SeleniumFunction newFunction() {
        SeleniumFunction function = new SeleniumFunction();
        function.getScriptLanguage().setValue((Object)"javascript");
        return function;
    }
}

