/*
 * Decompiled with CFR 0.152.
 */
package step.handlers.javahandler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import step.grid.agent.handler.AbstractMessageHandler;
import step.grid.agent.handler.context.OutputMessageBuilder;
import step.grid.agent.tokenpool.AgentTokenWrapper;
import step.grid.contextbuilder.ApplicationContextBuilder;
import step.grid.io.InputMessage;
import step.grid.io.OutputMessage;
import step.handlers.javahandler.AbstractKeyword;
import step.handlers.javahandler.Keyword;
import step.handlers.javahandler.KeywordException;

public class KeywordHandler
extends AbstractMessageHandler {
    public static final String KEYWORD_CLASSES = "$keywordClasses";
    private static final Logger logger = LoggerFactory.getLogger(KeywordHandler.class);
    private boolean throwExceptionOnError = false;

    public KeywordHandler() {
    }

    public KeywordHandler(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public boolean isThrowExceptionOnError() {
        return this.throwExceptionOnError;
    }

    public void setThrowExceptionOnError(boolean throwExceptionOnError) {
        this.throwExceptionOnError = throwExceptionOnError;
    }

    public OutputMessage handle(AgentTokenWrapper token, InputMessage message) throws Exception {
        ApplicationContextBuilder.ApplicationContext context = this.agentTokenServices.getApplicationContextBuilder().getCurrentContext();
        URLClassLoader cl = (URLClassLoader)context.getClassLoader();
        String kwClassnames = (String)message.getProperties().get(KEYWORD_CLASSES);
        if (kwClassnames != null && kwClassnames.trim().length() > 0) {
            for (String kwClassname : kwClassnames.split(";")) {
                Class<?> kwClass = cl.loadClass(kwClassname);
                for (Method m : kwClass.getDeclaredMethods()) {
                    Keyword annotation;
                    String annotatedFunctionName;
                    if (!m.isAnnotationPresent(Keyword.class) || ((annotatedFunctionName = (annotation = m.getAnnotation(Keyword.class)).name()) != null && annotatedFunctionName.length() != 0 || !m.getName().equals(message.getFunction())) && !annotatedFunctionName.equals(message.getFunction())) continue;
                    return this.invokeMethod(m, token, message);
                }
            }
        }
        throw new Exception("Unable to find method annoted by '" + Keyword.class.getName() + "' with name=='" + message.getFunction() + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OutputMessage invokeMethod(Method m, AgentTokenWrapper token, InputMessage message) throws Exception {
        OutputMessageBuilder output;
        block10: {
            Class<?> clazz = m.getDeclaringClass();
            Object instance = clazz.newInstance();
            if (logger.isDebugEnabled()) {
                logger.debug("Invoking method " + m.getName() + " from class " + clazz.getName() + " loaded by " + clazz.getClassLoader().toString());
            }
            Map properties = this.buildPropertyMap(token, message);
            if (logger.isDebugEnabled()) {
                logger.debug("Using property map: " + properties.toString());
            }
            output = new OutputMessageBuilder();
            if (instance instanceof AbstractKeyword) {
                AbstractKeyword script = (AbstractKeyword)instance;
                script.setTokenSession(token.getSession());
                script.setSession(token.getTokenReservationSession());
                script.setInput(message.getArgument());
                script.setProperties(properties);
                script.setOutputBuilder(output);
                try {
                    m.invoke(instance, new Object[0]);
                    break block10;
                }
                catch (Exception e) {
                    boolean throwException = script.onError(e);
                    if (throwException) {
                        Throwable cause = e.getCause();
                        Throwable reportedEx = e instanceof InvocationTargetException && cause != null && cause instanceof Throwable ? cause : e;
                        output.setError(reportedEx.getMessage() != null ? reportedEx.getMessage() : "Empty error message", reportedEx);
                        if (this.throwExceptionOnError) {
                            OutputMessage outputMessage = output.build();
                            throw new KeywordException(output.build(), outputMessage.getError(), reportedEx);
                        }
                    }
                    break block10;
                }
            }
            output.add("Info:", "The class '" + clazz.getName() + "' doesn't extend '" + AbstractKeyword.class.getName() + "'. Extend this class to get input parameters from STEP and return output.");
        }
        OutputMessage outputMessage = output.build();
        if (this.throwExceptionOnError && outputMessage.getError() != null) {
            throw new KeywordException(outputMessage, outputMessage.getError());
        }
        return outputMessage;
    }
}

