/*
 * Decompiled with CFR 0.152.
 */
package step.rtm;

import com.mongodb.client.MongoCollection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.rtm.commons.Configuration;
import org.rtm.commons.MeasurementAccessor;
import step.artefacts.reports.CallFunctionReportNode;
import step.core.GlobalContext;
import step.core.accessors.AbstractAccessor;
import step.core.artefacts.reports.ReportNode;
import step.core.plugins.AbstractPlugin;
import step.core.plugins.Plugin;
import step.core.reports.Measure;
import step.rtm.RtmPluginServices;

@Plugin
public class RtmPlugin
extends AbstractPlugin {
    MeasurementAccessor accessor;
    boolean measureReportNodes;

    public void executionControllerStart(GlobalContext context) throws Exception {
        context.getServiceRegistrationCallback().registerService(RtmPluginServices.class);
        Properties rtmProperties = Configuration.getInstance().getUnderlyingPropertyObject();
        step.commons.conf.Configuration stepProperties = step.commons.conf.Configuration.getInstance();
        if (stepProperties.getPropertyAsBoolean("plugins.rtm.useLocalDB", true)) {
            this.cloneProperty(rtmProperties, stepProperties, "db.host");
            this.cloneProperty(rtmProperties, stepProperties, "db.port");
            this.cloneProperty(rtmProperties, stepProperties, "db.database");
            this.cloneProperty(rtmProperties, stepProperties, "db.username");
            this.cloneProperty(rtmProperties, stepProperties, "db.password");
        }
        this.measureReportNodes = stepProperties.getPropertyAsBoolean("plugins.rtm.measurereportnodes", true);
        AbstractAccessor.createOrUpdateCompoundIndex((MongoCollection)context.getMongoClientSession().getMongoDatabase().getCollection("measurements"), (String[])new String[]{"eId", "begin"});
        WebAppContext webappCtx = new WebAppContext();
        webappCtx.setContextPath("/rtm");
        String war = step.commons.conf.Configuration.getInstance().getProperty("plugins.rtm.war");
        if (war == null) {
            throw new RuntimeException("Property 'plugins.rtm.war' is null. Unable to start RTM.");
        }
        File warFile = new File(war);
        if (!warFile.exists() || !warFile.canRead()) {
            throw new RuntimeException("The file '" + war + "' with absolute path '" + warFile.getAbsolutePath() + "' set by the property 'plugins.rtm.war' doesn't exist or cannot be read. Unable to start RTM.");
        }
        webappCtx.setWar(war);
        webappCtx.setParentLoaderPriority(true);
        context.getServiceRegistrationCallback().registerHandler((Handler)webappCtx);
        this.accessor = MeasurementAccessor.getInstance();
    }

    public void executionControllerDestroy(GlobalContext context) {
        if (this.accessor != null) {
            this.accessor.close();
        }
    }

    private void cloneProperty(Properties rtmProperties, step.commons.conf.Configuration stepProperties, String property) {
        if (stepProperties.getProperty(property) != null) {
            rtmProperties.put(property, stepProperties.getProperty(property));
        }
    }

    public void afterReportNodeExecution(ReportNode node) {
        if (node instanceof CallFunctionReportNode) {
            HashMap<String, Object> measurement;
            CallFunctionReportNode stepReport = (CallFunctionReportNode)node;
            ArrayList measurements = new ArrayList();
            if (this.measureReportNodes) {
                measurement = new HashMap<String, Object>();
                measurement.put("eId", stepReport.getExecutionID());
                measurement.put("name", stepReport.getFunctionAttributes().get("name"));
                measurement.put("value", Long.valueOf(stepReport.getDuration().intValue()));
                measurement.put("begin", stepReport.getExecutionTime());
                measurement.put("rnId", stepReport.getId().toString());
                measurement.put("rnStatus", stepReport.getStatus().toString());
                measurement.put("type", "keyword");
                measurements.add(measurement);
            }
            if (stepReport.getMeasures() != null) {
                for (Measure measure : stepReport.getMeasures()) {
                    measurement = new HashMap();
                    measurement.put("eId", stepReport.getExecutionID());
                    measurement.put("name", measure.getName());
                    measurement.put("value", measure.getDuration());
                    measurement.put("begin", measure.getBegin());
                    measurement.put("rnId", stepReport.getId().toString());
                    measurement.put("rnStatus", stepReport.getStatus().toString());
                    measurement.put("type", "custom");
                    if (measure.getData() != null) {
                        for (Map.Entry entry : measure.getData().entrySet()) {
                            String key = (String)entry.getKey();
                            Object val = entry.getValue();
                            if (key == null || val == null) continue;
                            if (val instanceof Long || val instanceof String) {
                                measurement.put(key, val);
                                continue;
                            }
                            if (!(val instanceof Number)) continue;
                            measurement.put(key, ((Integer)val).longValue());
                        }
                    }
                    measurements.add(measurement);
                }
            }
            this.accessor.saveManyMeasurements(measurements);
        }
    }
}

